/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.SubjectPublicKeyInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Iterator;

public class RSAPublicKey
implements PublicKey,
java.security.interfaces.RSAPublicKey {
    private Asn1 asn1 = null;
    private BigInteger modulus;
    private BigInteger exponent;

    protected RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.asn1 = new Sequence();
        this.modulus = bigInteger;
        this.exponent = bigInteger2;
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger));
        this.asn1.add(new com.dstc.security.asn1.Integer(bigInteger2));
    }

    protected RSAPublicKey(byte[] byArray) throws Asn1Exception, IOException {
        this.decode(Asn1.getAsn1(byArray));
    }

    private void decode(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.modulus = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
        this.exponent = ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            return Arrays.equals(this.getEncoded(), ((Key)object).getEncoded());
        }
        return false;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public byte[] getEncoded() {
        try {
            return new SubjectPublicKeyInfo(new AlgorithmId("1.2.840.113549.1.1.1", null), this.asn1.getEncoded()).getAsn1().getEncoded();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.exponent;
    }

    public String toString() {
        byte[] byArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 2) {
            if (n == 0) {
                stringBuffer.append("Modulus: \n            ");
                byArray = this.getModulus().toByteArray();
            } else {
                stringBuffer.append("\nPublic Exponent: \n            ");
                byArray = this.getPublicExponent().toByteArray();
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                if (n2 > 0 && n2 % 20 == 0) {
                    stringBuffer.append("\n            ");
                }
                if (byArray[n2] < 16 && byArray[n2] >= 0) {
                    stringBuffer.append("0" + Integer.toHexString(byArray[n2] & 0xFF) + " ");
                } else {
                    stringBuffer.append(String.valueOf(Integer.toHexString(byArray[n2] & 0xFF)) + " ");
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

