/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;

public class RawDSA
extends SignatureSpi {
    protected DSAPublicKey pubKey;
    protected DSAPrivateKey privKey;
    protected ByteArrayOutputStream bos = new ByteArrayOutputStream();
    protected MessageDigest md = null;
    protected byte[] buf = new byte[1];

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey.getAlgorithm().equals("DSA")) {
            if (privateKey instanceof DSAPrivateKey) {
                this.privKey = (DSAPrivateKey)privateKey;
            }
        } else {
            throw new InvalidKeyException("Not a DSA Private Key");
        }
        this.bos.reset();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey.getAlgorithm().equals("DSA")) {
            if (publicKey instanceof DSAPublicKey) {
                this.pubKey = (DSAPublicKey)publicKey;
            }
        } else {
            throw new InvalidKeyException("Not a DSA Public Key");
        }
        this.bos.reset();
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameter not supported");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        DSAParams dSAParams = this.privKey.getParams();
        BigInteger bigInteger = new BigInteger(dSAParams.getQ().bitLength() - 1, new Random());
        byte[] byArray = this.bos.toByteArray();
        if (byArray.length == 0) {
            throw new SignatureException("Nothing to sign");
        }
        this.bos.reset();
        BigInteger bigInteger2 = this.md != null ? new BigInteger(1, this.md.digest(byArray)) : new BigInteger(1, byArray);
        BigInteger bigInteger3 = dSAParams.getG().modPow(bigInteger, dSAParams.getP()).mod(dSAParams.getQ());
        BigInteger bigInteger4 = bigInteger3.multiply(this.privKey.getX()).add(bigInteger2);
        BigInteger bigInteger5 = bigInteger.modInverse(dSAParams.getQ());
        BigInteger bigInteger6 = bigInteger5.multiply(bigInteger4).mod(dSAParams.getQ());
        try {
            Sequence sequence = new Sequence();
            sequence.add(new Integer(bigInteger3));
            sequence.add(new Integer(bigInteger6));
            return sequence.getEncoded();
        }
        catch (Exception exception) {
            throw new SignatureException(exception.getMessage());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.buf[0] = by;
        this.engineUpdate(this.buf, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.bos.write(byArray, n, n2);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object;
        Object object2;
        try {
            object2 = Asn1.getAsn1(byArray);
            object = ((Asn1)object2).components();
            bigInteger2 = ((Integer)object.next()).getBigInteger();
            bigInteger = ((Integer)object.next()).getBigInteger();
        }
        catch (Exception exception) {
            throw new SignatureException("Badly formed signature");
        }
        object2 = this.pubKey.getParams();
        object = bigInteger.modInverse(object2.getQ());
        byte[] byArray2 = this.bos.toByteArray();
        if (byArray2.length == 0) {
            throw new SignatureException("Nothing to verify");
        }
        this.bos.reset();
        BigInteger bigInteger3 = this.md != null ? new BigInteger(1, this.md.digest(byArray2)) : new BigInteger(1, byArray2);
        BigInteger bigInteger4 = bigInteger3.multiply((BigInteger)object).mod(object2.getQ());
        BigInteger bigInteger5 = bigInteger2.multiply((BigInteger)object).mod(object2.getQ());
        BigInteger bigInteger6 = object2.getG().modPow(bigInteger4, object2.getP());
        BigInteger bigInteger7 = this.pubKey.getY().modPow(bigInteger5, object2.getP());
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7).mod(object2.getP()).mod(object2.getQ());
        return bigInteger8.equals(bigInteger2);
    }

    protected String getAlgorithm() {
        return "RawDSA";
    }
}

