/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class SymmetricKey
implements SecretKey {
    private static final String RAW = "RAW";
    private byte[] keyBytes;
    private String alg;

    SymmetricKey(String string, byte[] byArray) {
        this.alg = string;
        this.keyBytes = byArray;
    }

    SymmetricKey(String string, byte[] byArray, int n, int n2) {
        this.alg = string;
        this.keyBytes = new byte[n2];
        System.arraycopy(byArray, n, this.keyBytes, 0, n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            return Arrays.equals(this.getEncoded(), ((Key)object).getEncoded());
        }
        return false;
    }

    public String getAlgorithm() {
        return this.alg;
    }

    public byte[] getEncoded() {
        return this.keyBytes;
    }

    public String getFormat() {
        return RAW;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Key bytes: \n            ");
        int n = 0;
        while (n < this.keyBytes.length) {
            if (n > 0 && n % 20 == 0) {
                stringBuffer.append("\n            ");
            }
            if (this.keyBytes[n] < 16 && this.keyBytes[n] >= 0) {
                stringBuffer.append("0" + Integer.toHexString(this.keyBytes[n] & 0xFF) + " ");
            } else {
                stringBuffer.append(String.valueOf(Integer.toHexString(this.keyBytes[n] & 0xFF)) + " ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

