/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private static final int UNINITIALIZED = 0;
    private int state;
    private String transformation;
    private static final byte[] EMPTY = new byte[0];
    private Provider provider;
    private CipherSpi cipherSpi;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = string;
        this.state = 0;
    }

    public byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(EMPTY, 0, 0);
    }

    public byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(byArray, 0, byArray.length);
    }

    public int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.doFinal(EMPTY, 0, 0, byArray, n);
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(byArray, n, n2, byArray2, 0);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public int getBlockSize() {
        return this.cipherSpi.engineGetBlockSize();
    }

    public byte[] getIV() {
        return this.cipherSpi.engineGetIV();
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] providerArray = Security.getProviders();
        Cipher cipher = null;
        int n = 0;
        while (n < providerArray.length) {
            try {
                cipher = Cipher.getInstance(string, providerArray[n].getName());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException("Internal error: " + noSuchProviderException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (cipher != null) {
                return cipher;
            }
            ++n;
        }
        throw new NoSuchAlgorithmException("Cipher transformation " + string + " not found");
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (string2 == null) {
            throw new InvalidParameterException("Null provider supplied");
        }
        CipherSpi cipherSpi = null;
        Class<?> clazz = null;
        String string3 = null;
        try {
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string2 + " not found");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
            int n = stringTokenizer.countTokens();
            if (n != 1 && n != 3) {
                throw new NoSuchAlgorithmException("Cipher " + string + " not found in provider " + string2);
            }
            StringBuffer stringBuffer = new StringBuffer("Cipher.");
            StringBuffer stringBuffer2 = new StringBuffer("Alg.Alias.Cipher.");
            stringBuffer2.append(string);
            String string4 = Cipher.getProviderProperty(stringBuffer2.toString(), provider);
            if (string4 != null) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(string);
            }
            string3 = Cipher.getProviderProperty(stringBuffer.toString(), provider);
            if (string3 != null) {
                cipherSpi = (CipherSpi)Class.forName(string3).newInstance();
                return new Cipher(cipherSpi, provider, string);
            }
            if (n != 3) {
                throw new NoSuchAlgorithmException("Cipher " + string + " not found in provider " + string2);
            }
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            stringBuffer = new StringBuffer("Cipher.");
            stringBuffer2 = new StringBuffer("Alg.Alias.Cipher.");
            stringBuffer2.append(string5).append("/").append(string6);
            string4 = Cipher.getProviderProperty(stringBuffer2.toString(), provider);
            if (string4 != null) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(string5).append("/").append(string6);
            }
            string3 = Cipher.getProviderProperty(stringBuffer.toString(), provider);
            if (string3 != null) {
                clazz = Class.forName(string3);
                cipherSpi = (CipherSpi)clazz.newInstance();
                cipherSpi.engineSetPadding(string7);
                return new Cipher(cipherSpi, provider, string);
            }
            stringBuffer = new StringBuffer("Cipher.");
            stringBuffer2 = new StringBuffer("Alg.Alias.Cipher.");
            stringBuffer2.append(string5).append("//").append(string7);
            string4 = Cipher.getProviderProperty(stringBuffer2.toString(), provider);
            if (string4 != null) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(string5).append("//").append(string7);
            }
            string3 = Cipher.getProviderProperty(stringBuffer.toString(), provider);
            if (string3 != null) {
                clazz = Class.forName(string3);
                cipherSpi = (CipherSpi)clazz.newInstance();
                cipherSpi.engineSetMode(string6);
                return new Cipher(cipherSpi, provider, string);
            }
            stringBuffer = new StringBuffer("Cipher.");
            stringBuffer2 = new StringBuffer("Alg.Alias.Cipher.");
            stringBuffer2.append(string5);
            string4 = Cipher.getProviderProperty(stringBuffer2.toString(), provider);
            if (string4 != null) {
                stringBuffer.append(string4);
            } else {
                stringBuffer.append(string5);
            }
            string3 = Cipher.getProviderProperty(stringBuffer.toString(), provider);
            if (string3 != null) {
                clazz = Class.forName(string3);
                cipherSpi = (CipherSpi)clazz.newInstance();
                cipherSpi.engineSetPadding(string7);
                cipherSpi.engineSetMode(string6);
                return new Cipher(cipherSpi, provider, string);
            }
            throw new NoSuchAlgorithmException("Cipher " + string + " not found in provider " + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("Class " + string3 + " not found during Cipher instantiation");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("Transformation " + string + " not found in provider " + string2);
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException("Transformation " + string + " not found in provider " + string2);
        }
    }

    public int getOutputSize(int n) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        return this.cipherSpi.engineGetOutputSize(n);
    }

    public final AlgorithmParameters getParameters() {
        return this.cipherSpi.engineGetParameters();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = null;
        Enumeration enumeration = ((Hashtable)provider).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string3)) continue;
            string2 = ((Properties)provider).getProperty(string3);
            break;
        }
        return string2;
    }

    public void init(int n, Key key) throws InvalidKeyException {
        this.init(n, key, new SecureRandom());
    }

    public void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameters, new SecureRandom());
    }

    public void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = n;
        this.cipherSpi.engineInit(n, key, algorithmParameters, secureRandom);
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.state = n;
        this.cipherSpi.engineInit(n, key, secureRandom);
    }

    public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameterSpec, new SecureRandom());
    }

    public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = n;
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    public byte[] update(byte[] byArray) throws IllegalStateException {
        return this.update(byArray, 0, byArray.length);
    }

    public byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2);
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        return this.update(byArray, n, n2, byArray2, 0);
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, n3);
    }
}

