/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private Cipher cipher;
    private byte[] buffer;
    private int blockSize;
    private int bufferStart = 0;
    private int bufferLen = 0;
    private boolean eof = false;
    private byte[] buf;

    protected CipherInputStream(InputStream inputStream) {
        super(inputStream);
        this.cipher = new NullCipher();
        this.blockSize = this.cipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
        this.blockSize = cipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
    }

    public int available() throws IOException {
        try {
            return this.cipher.getOutputSize(this.in.available()) + this.bufferLen;
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n;
        do {
            if ((n = this.read(this.buf, 0, 1)) != -1) continue;
            return -1;
        } while (n != 1);
        return this.buf[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eof && this.bufferLen == 0) {
            return -1;
        }
        int n3 = 0;
        if (n2 <= this.bufferLen) {
            System.arraycopy(this.buffer, this.bufferStart, byArray, n, n2);
            this.bufferStart += n2;
            this.bufferLen -= n2;
            return n3 += n2;
        }
        int n4 = n2 - this.bufferLen;
        System.arraycopy(this.buffer, this.bufferStart, byArray, n, this.bufferLen);
        n3 += this.bufferLen;
        n += this.bufferLen;
        this.bufferStart = 0;
        this.bufferLen = 0;
        if (this.eof) {
            return n3;
        }
        try {
            byte[] byArray2 = new byte[n4];
            int n5 = this.in.read(byArray2, 0, n4);
            if (n5 == -1) {
                this.eof = true;
                int n6 = n2 - n;
                int n7 = this.cipher.doFinal(this.buf, 0);
                if (n6 < n7) {
                    System.arraycopy(this.buf, 0, byArray, n, n6);
                    this.bufferLen = n7 - n6;
                    System.arraycopy(this.buf, n6, this.buffer, 0, this.bufferLen);
                    return n3 += n6;
                }
                System.arraycopy(this.buf, 0, byArray, n, n7);
                return n3 += n7;
            }
            byte[] byArray3 = new byte[this.cipher.getOutputSize(n4)];
            int n8 = this.cipher.update(byArray2, 0, n5, byArray3, 0);
            if (n4 <= n8) {
                System.arraycopy(byArray3, 0, byArray, n, n4);
                this.bufferLen = n8 - n4;
                System.arraycopy(byArray3, n4, this.buffer, 0, this.bufferLen);
                return n3 += n4;
            }
            System.arraycopy(byArray3, 0, byArray, n, n8);
            this.bufferLen = 0;
            return n3 += n8;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IOException("Cipher in wrong state");
        }
        catch (ShortBufferException shortBufferException) {
            throw new IOException(shortBufferException.toString());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException(illegalBlockSizeException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.toString());
        }
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        return this.read(byArray, 0, (int)l);
    }
}

