/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherOutputStream
extends FilterOutputStream {
    private Cipher cipher;
    private byte[] buf = new byte[1];
    private byte[] buffer = new byte[0];

    protected CipherOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.cipher = new NullCipher();
    }

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        this.cipher = cipher;
    }

    public void close() throws IOException {
        try {
            byte[] byArray = this.cipher.doFinal();
            this.out.write(byArray, 0, byArray.length);
            this.out.flush();
            this.out.close();
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException("Bad padding encountered: " + badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException("Illegal block size: " + illegalBlockSizeException.getMessage());
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int n) throws IOException {
        this.buf[0] = (byte)(n & 0xFF);
        this.write(this.buf, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        int n3 = this.cipher.getOutputSize(n2);
        if (this.buffer.length < n3) {
            this.buffer = new byte[n3];
        }
        try {
            int n4 = this.cipher.update(byArray, n, n2, this.buffer, 0);
            this.out.write(this.buffer, 0, n4);
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("Internal error: " + shortBufferException.getMessage());
        }
    }
}

