/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private KeyGeneratorSpi delegate;
    private Provider provider;
    private String algorithm;

    protected KeyGenerator(KeyGeneratorSpi keyGeneratorSpi, Provider provider, String string) {
        this.delegate = keyGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final SecretKey generateKey() {
        return this.delegate.engineGenerateKey();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        KeyGenerator keyGenerator = null;
        int n = 0;
        while (n < providerArray.length) {
            try {
                keyGenerator = KeyGenerator.getInstance(string, providerArray[n].getName());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException("Internal error: " + noSuchProviderException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (keyGenerator != null) {
                return keyGenerator;
            }
            ++n;
        }
        throw new NoSuchAlgorithmException("KeyGenerator algorithm " + string + " not supported");
    }

    public static final KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new InvalidParameterException("Null provider supplied");
        }
        try {
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string2 + " not found");
            }
            StringBuffer stringBuffer = new StringBuffer("KeyGenerator.");
            StringBuffer stringBuffer2 = new StringBuffer("Alg.Alias.KeyGenerator.");
            stringBuffer2.append(string);
            String string3 = KeyGenerator.getProviderProperty(stringBuffer2.toString(), provider);
            if (string3 != null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string);
            }
            String string4 = KeyGenerator.getProviderProperty(stringBuffer.toString(), provider);
            Class<?> clazz = Class.forName(string4);
            return new KeyGenerator((KeyGeneratorSpi)clazz.newInstance(), provider, string);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " not found in provider " + string2);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = null;
        Enumeration enumeration = ((Hashtable)provider).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string3)) continue;
            string2 = ((Properties)provider).getProperty(string3);
            break;
        }
        return string2;
    }

    public final void init(int n) {
        this.init(n, new SecureRandom());
    }

    public final void init(int n, SecureRandom secureRandom) {
        this.delegate.engineInit(n, secureRandom);
    }

    public final void init(SecureRandom secureRandom) {
        this.delegate.engineInit(secureRandom);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.init(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.delegate.engineInit(algorithmParameterSpec, secureRandom);
    }
}

