/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class NullCipher
extends Cipher {
    private static final int UNINITIALIZED = 0;
    private int state = 0;

    public NullCipher() {
        super(null, null, null);
    }

    public byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        this.state = 0;
        return new byte[0];
    }

    public byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        this.state = 0;
        return (byte[])byArray.clone();
    }

    public int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        this.state = 0;
        return 0;
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.state = 0;
        return byArray2;
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(byArray, n, n2, byArray2, 0);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray2.length - n3 < n2) {
            throw new ShortBufferException("Buffer too short");
        }
        System.arraycopy(byArray, n, byArray2, n3, n2);
        this.state = 0;
        return n2;
    }

    public int getBlockSize() {
        return 1;
    }

    public byte[] getIV() {
        return new byte[0];
    }

    public int getOutputSize(int n) throws IllegalStateException {
        return n;
    }

    public void init(int n, Key key) throws InvalidKeyException {
        this.state = n;
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.state = n;
    }

    public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = n;
    }

    public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = n;
    }

    public byte[] update(byte[] byArray) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        return (byte[])byArray.clone();
    }

    public byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        return this.update(byArray, n, n2, byArray2, 0);
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (byArray2.length - n3 < n2) {
            throw new ShortBufferException("Buffer too short");
        }
        System.arraycopy(byArray, n, byArray2, n3, n2);
        return n2;
    }
}

