/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;

public class SecretKeyFactory {
    private SecretKeyFactorySpi delegate;
    private Provider provider;
    private String algorithm;

    protected SecretKeyFactory(SecretKeyFactorySpi secretKeyFactorySpi, Provider provider, String string) {
        this.delegate = secretKeyFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.delegate.engineGenerateSecret(keySpec);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final SecretKeyFactory getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        SecretKeyFactory secretKeyFactory = null;
        int n = 0;
        while (n < providerArray.length) {
            try {
                secretKeyFactory = SecretKeyFactory.getInstance(string, providerArray[n].getName());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new RuntimeException("Internal error: " + noSuchProviderException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (secretKeyFactory != null) {
                return secretKeyFactory;
            }
            ++n;
        }
        throw new NoSuchAlgorithmException("SecretKeyFactory algorithm " + string + " not supported");
    }

    public static final SecretKeyFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new InvalidParameterException("Null provider supplied");
        }
        try {
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string2 + " not found");
            }
            StringBuffer stringBuffer = new StringBuffer("SecretKeyFactory.");
            StringBuffer stringBuffer2 = new StringBuffer("Alg.Alias.SecretKeyFactory.");
            stringBuffer2.append(string);
            String string3 = SecretKeyFactory.getProviderProperty(stringBuffer2.toString(), provider);
            if (string3 != null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string);
            }
            String string4 = SecretKeyFactory.getProviderProperty(stringBuffer.toString(), provider);
            Class<?> clazz = Class.forName(string4);
            return new SecretKeyFactory((SecretKeyFactorySpi)clazz.newInstance(), provider, string);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " not found in provider " + string2);
        }
    }

    public final KeySpec getKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        return this.delegate.engineGetKeySpec(secretKey, clazz);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = null;
        Enumeration enumeration = ((Hashtable)provider).keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string3)) continue;
            string2 = ((Properties)provider).getProperty(string3);
            break;
        }
        return string2;
    }

    public final SecretKey translateKey(SecretKey secretKey) throws InvalidKeyException {
        return this.delegate.engineTranslateKey(secretKey);
    }
}

