/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private static final byte[][] WEAK_KEYS = new byte[][]{{1, 1, 1, 1, 1, 1, 1, 1}, {31, 31, 31, 31, -32, -32, -32, -32}, {-32, -32, -32, -32, 31, 31, 31, 31}, {-2, -2, -2, -2, -2, -2, -2, -2}};
    private static final byte[][] SEMI_WEAK_KEYS = new byte[][]{{1, -2, 1, -2, 1, -2, 1, -2}, {31, -32, 31, -32, 14, -15, 14, -15}, {1, -32, 1, -32, 1, -15, 1, -15}, {31, -2, 31, -2, 14, -2, 14, -2}, {1, 31, 1, 31, 1, 14, 1, 14}, {-32, -2, -32, -2, -15, -2, -15, -2}};
    private byte[] keyBytes;

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Key too short");
        }
        this.keyBytes = new byte[8];
        System.arraycopy(byArray, n, this.keyBytes, 0, 8);
    }

    public byte[] getKey() {
        return this.keyBytes;
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        int n2 = n;
        while (n2 < byArray.length) {
            int n3 = 0;
            int n4 = 7;
            while (n4 >= 0) {
                n3 += byArray[n2] >>> n4 & 1;
                --n4;
            }
            if (n3 % 2 == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isWeak(byte[] byArray, int n) throws InvalidKeyException {
        int n2;
        int n3;
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Key too short");
        }
        int n4 = n;
        while (n4 < n + 8) {
            switch (byArray[n4]) {
                default: {
                    return false;
                }
                case -32: 
                case -15: 
                case -2: 
                case 1: 
                case 14: 
                case 31: 
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < 4) {
            n3 = 1;
            n2 = 0;
            while (n2 < 8) {
                if (WEAK_KEYS[n5][n2] != byArray[n + n2]) {
                    n3 = 0;
                    break;
                }
                ++n2;
            }
            if (n3 != 0) {
                return true;
            }
            ++n5;
        }
        n3 = 0;
        while (n3 < 6) {
            n2 = 1;
            int n6 = 0;
            while (n6 < 8) {
                if (SEMI_WEAK_KEYS[n3][n6] != byArray[n + n6]) {
                    n2 = 0;
                    break;
                }
                ++n6;
            }
            int n7 = 0;
            while (n7 < 8) {
                int n8;
                int n9 = n8 = n7 % 2 == 0 ? 1 : -1;
                if (SEMI_WEAK_KEYS[n3][n7 + n8] != byArray[n + n7]) {
                    n2 = 0;
                    break;
                }
                ++n7;
            }
            if (n2 != 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

