/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private int version;
    private int rounds;
    private int wordSize;
    private byte[] iv = null;

    public RC5ParameterSpec(int n, int n2, int n3) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, 0);
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray, int n4) {
        if (byArray == null) {
            throw new IllegalArgumentException("IV is null");
        }
        if (4 * (byArray.length - n4) != n3) {
            throw new IllegalArgumentException("IV length not equal to twice wordsize");
        }
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
        this.iv = new byte[n3 / 4];
        System.arraycopy(byArray, n4, this.iv, 0, n3 / 4);
    }

    public byte[] getIV() {
        return this.iv;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getVersion() {
        return this.version;
    }

    public int getWordSize() {
        return this.wordSize;
    }
}

