/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private String algorithm;
    private byte[] keyMaterial;

    public SecretKeySpec(byte[] byArray, int n, int n2, String string) {
        if (byArray.length - n < n2) {
            throw new RuntimeException("Key too short");
        }
        this.algorithm = string;
        this.keyMaterial = new byte[n2];
        System.arraycopy(byArray, n, this.keyMaterial, 0, n2);
    }

    public SecretKeySpec(byte[] byArray, String string) {
        this(byArray, 0, byArray.length, string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SecretKeySpec)) {
            return false;
        }
        if (!this.algorithm.equals(((SecretKeySpec)object).algorithm)) {
            return false;
        }
        return Arrays.equals(this.keyMaterial, ((SecretKeySpec)object).keyMaterial);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        return this.keyMaterial;
    }

    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        throw new RuntimeException("Not yet implemented");
    }
}

