/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.asn1;

import com.dstc.security.asn1.Asn1EncodingException;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Asn1String;
import com.dstc.security.asn1.BMPString;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.Enumerated;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Null;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.PrintableString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import com.dstc.security.asn1.T61String;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.asn1.UTF8String;
import com.dstc.security.asn1.UniversalString;
import com.dstc.security.asn1.VisibleString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Asn1 {
    private static final boolean debug = true;
    public static final int TAG_CLASS_UNIVERSAL = 0;
    public static final int TAG_CLASS_APPLICATION = 64;
    public static final int TAG_CLASS_CONTEXT = 128;
    public static final int TAG_CLASS_PRIVATE = 192;
    public static final int MASK_CLASS = 192;
    public static final int TAG_PRIMITIVE = 0;
    public static final int TAG_CONSTRUCTED = 32;
    public static final int MASK_CONSTRUCTED = 32;
    public static final byte TAG_BOOLEAN = 1;
    public static final byte TAG_INTEGER = 2;
    public static final byte TAG_BITSTRING = 3;
    public static final byte TAG_OCTETSTRING = 4;
    public static final byte TAG_NULL = 5;
    public static final byte TAG_OID = 6;
    public static final byte TAG_ENUMERATED = 10;
    public static final byte TAG_SEQUENCE = 16;
    public static final byte TAG_SET = 17;
    public static final byte TAG_UTF8STRING = 12;
    public static final byte TAG_PRINTABLESTRING = 19;
    public static final byte TAG_T61STRING = 20;
    public static final byte TAG_IA5STRING = 22;
    public static final byte TAG_UTCTIME = 23;
    public static final byte TAG_GENERALIZEDTIME = 24;
    public static final byte TAG_VISIBLESTRING = 26;
    public static final byte TAG_GENERALSTRING = 27;
    public static final byte TAG_UNIVERSALSTRING = 28;
    public static final byte TAG_BMPSTRING = 30;
    public static final byte MASK_NUMBER = 31;
    private static final int DECODING = 1;
    private static int BER_BUF_LEN = 512;
    private int state;
    protected int depth = 0;
    protected int tag;
    protected int length;
    protected byte[] value = null;
    protected InputStream contentsIn = null;
    protected Vector components = null;
    protected boolean isStructured = false;
    protected int encodingLength = 0;
    protected boolean lengthKnown = true;
    protected Asn1ComponentIterator it;
    private boolean done = false;
    private boolean headerDone = false;
    private Iterator encIt = null;
    private Asn1 encComp = null;

    public void add(Asn1 asn1) {
        this.components.add(asn1);
        if (this.lengthKnown()) {
            this.lengthKnown &= asn1.lengthKnown;
            this.length += asn1.encodingLength;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] berEncode() throws IOException, Asn1Exception {
        if (this.done) {
            return null;
        }
        if (this.lengthKnown()) {
            this.done = true;
            return this.getEncoded();
        }
        if (!this.headerDone) {
            this.headerDone = true;
            return new byte[]{(byte)(0xFF & this.tag), -128};
        }
        if (this.contentsIn != null) {
            byte[] byArray = this.encodeFromStream();
            if (byArray != null) return byArray;
            this.done = true;
            return new byte[2];
        } else {
            byte[] byArray = null;
            while (true) {
                if (this.encIt == null) {
                    this.encIt = ((AbstractList)this.components).iterator();
                    if (this.encIt == null) return new byte[2];
                    this.encComp = (Asn1)this.encIt.next();
                }
                if ((byArray = this.encComp.berEncode()) != null) return byArray;
                if (!this.encIt.hasNext()) break;
                this.encComp = (Asn1)this.encIt.next();
            }
            this.done = true;
        }
        return new byte[2];
    }

    public void berEncode(OutputStream outputStream) throws IOException, Asn1Exception {
        byte[] byArray = null;
        while ((byArray = this.berEncode()) != null) {
            outputStream.write(byArray);
        }
    }

    public Iterator components() {
        if (!this.lengthKnown() && this.state == 1) {
            return this.it;
        }
        if (this.components == null) {
            return null;
        }
        return ((AbstractList)this.components).iterator();
    }

    private void decode(int n, InputStream inputStream) throws IOException {
        this.state = 1;
        this.tag = n;
        ++this.encodingLength;
        this.readLength(inputStream);
        if (this.isConstructed()) {
            if (!this.lengthKnown()) {
                this.it = new Asn1ComponentIterator(inputStream);
            } else {
                int n2 = 0;
                this.components = new Vector();
                while (n2 != this.length) {
                    Asn1 asn1 = Asn1.getAsn1(inputStream);
                    this.components.add(asn1);
                    n2 += asn1.encodingLength;
                    this.encodingLength += asn1.encodingLength;
                }
            }
        } else {
            this.readValue(inputStream);
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException, Asn1Exception {
        if (!this.lengthKnown()) {
            throw new Asn1EncodingException("Length unknown: cannot DER encode");
        }
        outputStream.write((byte)(0xFF & this.tag));
        if (this.isConstructed()) {
            Iterator iterator = this.components();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (iterator.hasNext()) {
                ((Asn1)iterator.next()).derEncode(byteArrayOutputStream);
            }
            this.value = byteArrayOutputStream.toByteArray();
        }
        this.length = this.value.length;
        this.writeLengthOctets(this.length, outputStream);
        outputStream.write(this.value);
    }

    public void encode(OutputStream outputStream) throws IOException, Asn1Exception {
        this.berEncode(outputStream);
    }

    private byte[] encodeFromStream() throws IOException, Asn1Exception {
        byte[] byArray = new byte[BER_BUF_LEN];
        int n = this.contentsIn.read(byArray);
        if (n == -1) {
            return null;
        }
        return new OctetString(byArray, 0, n).getEncoded();
    }

    public Asn1 getAsAsn1Tagged(int n) {
        int n2 = n;
        if ((n & 0xC0) != 0) {
            throw new IllegalArgumentException("Universal tag type expected");
        }
        if ((this.tag & 0x20) == 32) {
            n2 = n | 0x20;
        }
        Asn1 asn1 = Asn1.getAsn1ForTag(n2);
        asn1.tag = n2;
        asn1.state = this.state;
        asn1.depth = this.depth;
        asn1.length = this.length;
        asn1.value = this.value;
        asn1.contentsIn = this.contentsIn;
        asn1.components = this.components;
        asn1.isStructured = this.isStructured;
        asn1.encodingLength = this.encodingLength;
        asn1.lengthKnown = this.lengthKnown;
        asn1.it = this.it;
        return asn1;
    }

    public static Asn1 getAsn1(InputStream inputStream) throws IOException {
        int n = Asn1.readTag(inputStream);
        Asn1 asn1 = Asn1.getAsn1ForTag(n);
        asn1.decode(n, inputStream);
        return asn1;
    }

    public static Asn1 getAsn1(byte[] byArray) throws Asn1Exception {
        try {
            return Asn1.getAsn1(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private static Asn1 getAsn1ForTag(int n) {
        Asn1 asn1 = null;
        if ((n & 0xC0) == 0) {
            switch (n & 0x1F) {
                case 16: {
                    asn1 = new Sequence();
                    break;
                }
                case 17: {
                    asn1 = new Set();
                    break;
                }
                case 6: {
                    asn1 = new Oid();
                    break;
                }
                case 2: {
                    asn1 = new Integer();
                    break;
                }
                case 10: {
                    asn1 = new Enumerated();
                    break;
                }
                case 4: {
                    asn1 = new OctetString();
                    break;
                }
                case 3: {
                    asn1 = new BitString();
                    break;
                }
                case 1: {
                    asn1 = new Boolean();
                    break;
                }
                case 24: {
                    asn1 = new GeneralizedTime();
                    break;
                }
                case 23: {
                    asn1 = new UTCTime();
                    break;
                }
                case 5: {
                    asn1 = new Null();
                    break;
                }
                case 19: {
                    asn1 = new PrintableString();
                    break;
                }
                case 22: {
                    asn1 = new IA5String();
                    break;
                }
                case 20: {
                    asn1 = new T61String();
                    break;
                }
                case 12: {
                    asn1 = new UTF8String();
                    break;
                }
                case 30: {
                    asn1 = new BMPString();
                    break;
                }
                case 28: {
                    asn1 = new UniversalString();
                    break;
                }
                case 26: {
                    asn1 = new VisibleString();
                    break;
                }
                case 27: {
                    asn1 = new GeneralString();
                    break;
                }
                default: {
                    asn1 = new Asn1();
                    break;
                }
            }
        } else {
            asn1 = new Asn1();
            asn1.components = new Vector();
        }
        return asn1;
    }

    public byte[] getEncoded() throws Asn1Exception {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.derEncode(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public final int getTagClass() {
        return this.tag & 0xC0;
    }

    public final int getTagNumber() {
        return this.tag & 0x1F;
    }

    public byte[] getValue() {
        return this.value;
    }

    private static final String hexDigit(byte by) {
        char[] cArray = new char[2];
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[0] = c;
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[1] = c;
        return new String(cArray);
    }

    public final void info() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.info(stringBuffer, 0);
        System.out.println(stringBuffer.toString());
    }

    private void info(StringBuffer stringBuffer, int n) throws IOException {
        this.depth = n + 1;
        this.spit(stringBuffer);
        block0 : switch (this.getTagClass()) {
            case 64: {
                stringBuffer.append("[APPLICATION " + this.getTagNumber() + "]");
                break;
            }
            case 128: {
                stringBuffer.append("[CONTEXT-SPECIFIC " + this.getTagNumber() + "]");
                break;
            }
            case 192: {
                stringBuffer.append("[PRIVATE " + this.getTagNumber() + "]");
                break;
            }
            case 0: {
                switch (this.getTagNumber()) {
                    case 4: {
                        stringBuffer.append("OCTET STRING");
                        break block0;
                    }
                    case 2: {
                        stringBuffer.append("INTEGER");
                        break block0;
                    }
                    case 6: {
                        stringBuffer.append("OBJECT IDENTIFIER ");
                        stringBuffer.append(((Oid)this).getOid()).append("\n");
                        return;
                    }
                    case 1: {
                        stringBuffer.append("BOOLEAN ");
                        if (((Boolean)this).isTrue()) {
                            stringBuffer.append("TRUE\n");
                        } else {
                            stringBuffer.append("FALSE\n");
                        }
                        return;
                    }
                    case 3: {
                        stringBuffer.append("BIT STRING");
                        this.printHex(stringBuffer, ((BitString)this).getBytes());
                        return;
                    }
                    case 23: {
                        stringBuffer.append("UTC TIME ");
                        stringBuffer.append(((UTCTime)this).getTime()).append("\n");
                        return;
                    }
                    case 24: {
                        stringBuffer.append("GENERALIZED TIME ");
                        stringBuffer.append(new String(this.value)).append("\n");
                        return;
                    }
                    case 5: {
                        stringBuffer.append("NULL").append("\n");
                        return;
                    }
                    case 16: {
                        stringBuffer.append("SEQUENCE");
                        break block0;
                    }
                    case 17: {
                        stringBuffer.append("SET");
                        break block0;
                    }
                    case 12: 
                    case 19: 
                    case 20: 
                    case 22: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 30: {
                        stringBuffer.append(((Asn1String)this).stringType).append(" STRING ");
                        stringBuffer.append("'").append(((Asn1String)this).getString()).append("'\n");
                        return;
                    }
                }
            }
        }
        if (this.isConstructed()) {
            stringBuffer.append(" {\n");
            Iterator iterator = this.components();
            while (iterator.hasNext()) {
                Asn1 asn1 = (Asn1)iterator.next();
                if (asn1 == null) break;
                asn1.info(stringBuffer, this.depth);
            }
            this.spit(stringBuffer);
            stringBuffer.append("}\n");
        } else {
            this.printHex(stringBuffer, this.value);
        }
    }

    public boolean isClassUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    private boolean lengthKnown() {
        return this.lengthKnown;
    }

    private final void printHex(StringBuffer stringBuffer, byte[] byArray) {
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                if (n % 16 == 0) {
                    stringBuffer.append("\n ");
                    int n2 = 0;
                    while (n2 < this.depth) {
                        stringBuffer.append("  ");
                        ++n2;
                    }
                }
                stringBuffer.append(Asn1.hexDigit(byArray[n])).append(" ");
                ++n;
            }
        }
        stringBuffer.append("\n");
    }

    private void readLength(InputStream inputStream) throws IOException {
        byte by = (byte)(inputStream.read() & 0xFF);
        ++this.encodingLength;
        if (by == -128) {
            this.lengthKnown = false;
            this.length = -1;
            return;
        }
        if ((by & 0x80) == 0) {
            this.lengthKnown = true;
            this.length = by;
        } else {
            int n = by & 0x7F;
            byte[] byArray = new byte[n];
            this.encodingLength += n;
            for (int i = 0; i != n; i += inputStream.read(byArray, i, n - i)) {
            }
            this.length = 0;
            int n2 = 0;
            while (n2 < n) {
                this.length |= (byArray[n2] & 0xFF) << 8 * (n - 1 - n2);
                ++n2;
            }
        }
    }

    private static int readTag(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new IOException("Unexpected end of stream encountered");
        }
        return n;
    }

    private void readValue(InputStream inputStream) throws IOException {
        if (this.length == 0) {
            this.value = new byte[0];
            return;
        }
        this.value = new byte[this.length];
        for (int i = 0; i != this.length; i += inputStream.read(this.value, i, this.length - i)) {
        }
        this.encodingLength += this.length;
    }

    public final void setTagClass(int n) {
        this.tag = this.tag & 0x1F | this.tag & 0x20 | n;
    }

    public final void setTagNumber(int n) {
        this.tag = this.tag & 0xC0 | this.tag & 0x20 | n;
    }

    private final void spit(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.depth) {
            stringBuffer.append("  ");
            ++n;
        }
    }

    private void writeLengthOctets(int n, OutputStream outputStream) throws IOException {
        if (n < 128) {
            outputStream.write(n);
        } else {
            byte[] byArray = new byte[16];
            int n2 = 0;
            do {
                byArray[n2++] = (byte)n;
            } while ((n >>>= 8) != 0);
            outputStream.write((byte)(n2 | 0x80));
            int n3 = 0;
            while (n3 < n2) {
                outputStream.write(byArray[n2 - 1 - n3]);
                ++n3;
            }
        }
    }

    public byte[] writeValue() {
        if (this.done) {
            return null;
        }
        if (!this.isConstructed()) {
            this.done = true;
            return this.getValue();
        }
        if (this.encIt == null) {
            this.encIt = this.components();
            this.encComp = (Asn1)this.encIt.next();
        } else if (this.encComp.done) {
            if (this.encIt.hasNext()) {
                this.encComp = (Asn1)this.encIt.next();
            } else {
                this.done = true;
                return null;
            }
        }
        if (this.encComp == null) {
            this.done = true;
            return null;
        }
        byte[] byArray = this.encComp.writeValue();
        if (byArray == null) {
            this.done = true;
        }
        return byArray;
    }

    public void writeValue(OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        while ((byArray = this.writeValue()) != null) {
            outputStream.write(byArray);
        }
    }

    class Asn1ComponentIterator
    implements Iterator {
        private InputStream is;
        private boolean hasNext = true;
        private Asn1 next = null;
        private Asn1 previous = null;

        Asn1ComponentIterator(InputStream inputStream) {
            this.is = inputStream;
        }

        public boolean hasNext() {
            if (!this.hasNext) {
                return this.hasNext;
            }
            if (this.next != null) {
                return this.hasNext;
            }
            if (this.previous != null) {
                if (this.previous.isConstructed()) {
                    Iterator iterator = this.previous.components();
                    while (iterator.hasNext()) {
                        Asn1 asn1 = (Asn1)iterator.next();
                    }
                }
                this.previous = null;
            }
            this.next = this.read();
            if (this.next == null) {
                this.hasNext = false;
            }
            return this.hasNext;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.previous = this.next;
            this.next = null;
            return this.previous;
        }

        private Asn1 read() {
            try {
                Asn1 asn1 = Asn1.getAsn1(this.is);
                if (asn1.tag == 0 && asn1.length == 0) {
                    return null;
                }
                return asn1;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Asn1DecodingException" + iOException.toString());
            }
        }

        public void remove() {
        }
    }
}

