/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.certpath;

import com.dstc.security.certpath.CertPath;
import com.dstc.security.certpath.CertPathException;
import com.dstc.security.certpath.NoTrustAnchorException;
import com.dstc.security.certpath.X509CertChecker;
import com.dstc.security.certpath.X509CertSelector;
import com.dstc.security.common.X500Name;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class CertPathBuilder {
    private Vector trustedCerts = null;

    public CertPathBuilder() {
    }

    public CertPathBuilder(Vector vector) {
        this.setTrustedCerts(vector);
    }

    public CertPath build(Collection collection, X509CertSelector x509CertSelector) throws CertPathException, CertificateException {
        Vector vector = this.doNameChaining(collection, x509CertSelector);
        X509Certificate[] x509CertificateArray = new X509Certificate[vector.size()];
        vector.toArray(x509CertificateArray);
        this.verify(x509CertificateArray);
        return new CertPath(x509CertificateArray);
    }

    private static void checkCert(X509Certificate x509Certificate, X509CertChecker x509CertChecker, Date date) throws CertificateException {
        x509Certificate.checkValidity();
        if (x509CertChecker != null) {
            x509CertChecker.checkCert(x509Certificate, date);
        }
    }

    private Vector doNameChaining(Collection collection, X509CertSelector x509CertSelector) throws CertPathException {
        X509Certificate x509Certificate;
        Iterator iterator;
        Vector vector;
        Vector<X509Certificate> vector2;
        block3: {
            vector2 = new Vector<X509Certificate>();
            vector = new Vector(collection);
            iterator = ((AbstractList)vector).iterator();
            do {
                if (!x509CertSelector.match(x509Certificate = (X509Certificate)iterator.next())) continue;
                vector2.add(x509Certificate);
                vector.removeElement(x509Certificate);
                break block3;
            } while (iterator.hasNext());
            throw new CertPathException("End-entity cert not found");
        }
        while (!vector.isEmpty()) {
            iterator = ((AbstractList)vector).iterator();
            Principal principal = x509Certificate.getIssuerDN();
            if (x509Certificate.getSubjectDN().equals(principal)) break;
            do {
                if (iterator.hasNext()) continue;
                return vector2;
            } while (!(x509Certificate = (X509Certificate)iterator.next()).getSubjectDN().equals(principal));
            vector2.addElement(x509Certificate);
            vector.removeElement(x509Certificate);
        }
        return vector2;
    }

    public Vector getTrustedCerts() {
        return this.trustedCerts;
    }

    public void setTrustedCerts(Vector vector) {
        this.trustedCerts = vector;
    }

    public void verify(X509Certificate[] x509CertificateArray) throws NoTrustAnchorException, CertPathException, CertificateException {
        this.verify(x509CertificateArray, null);
    }

    public void verify(X509Certificate[] x509CertificateArray, X509CertChecker x509CertChecker) throws NoTrustAnchorException, CertPathException, CertificateException {
        if (this.trustedCerts == null) {
            throw new CertPathException("No trusted certs set");
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new CertPathException("Cert path must contain at least one cert");
        }
        Date date = new Date();
        try {
            int n = 0;
            X509Certificate x509Certificate = x509CertificateArray[n];
            while (n != x509CertificateArray.length - 1) {
                CertPathBuilder.checkCert(x509Certificate, x509CertChecker, date);
                X509Certificate x509Certificate2 = x509CertificateArray[++n];
                x509Certificate.verify(x509Certificate2.getPublicKey());
                x509Certificate = x509Certificate2;
            }
            Principal principal = x509Certificate.getIssuerDN();
            boolean bl = X500Name.equals(principal, x509Certificate.getSubjectDN());
            Iterator iterator = ((AbstractList)this.trustedCerts).iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate3 = (X509Certificate)iterator.next();
                if (!X500Name.equals(principal, x509Certificate3.getSubjectDN())) continue;
                if (bl) {
                    CertPathBuilder.checkCert(x509Certificate, x509CertChecker, date);
                    boolean bl2 = Arrays.equals(x509Certificate.getEncoded(), x509Certificate3.getEncoded());
                    x509Certificate.verify(x509Certificate3.getPublicKey());
                    return;
                }
                CertPathBuilder.checkCert(x509Certificate, x509CertChecker, date);
                x509Certificate.verify(x509Certificate3.getPublicKey());
                return;
            }
            throw new NoTrustAnchorException("No trust anchor for this path");
        }
        catch (SignatureException signatureException) {
            throw new CertPathException("Bad signature on cert");
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertPathException(invalidKeyException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CertPathException(generalSecurityException.getMessage());
        }
    }
}

