/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.certpath;

import com.dstc.security.certpath.CertPathBuilder;
import com.dstc.security.certpath.CertPathException;
import com.dstc.security.certpath.X509CertChecker;
import com.dstc.security.util.Base64OutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;

public class TrustEngine {
    private static final boolean OFFER = false;
    private CertPathBuilder cpb;

    public TrustEngine() {
        this.cpb = new CertPathBuilder();
    }

    public TrustEngine(Vector vector) {
        this.cpb = new CertPathBuilder(vector);
    }

    public TrustEngine(X509Certificate[] x509CertificateArray) {
        this(TrustEngine.arrayToVec(x509CertificateArray));
    }

    static Vector arrayToVec(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    public Vector getTrustedCerts() {
        return this.cpb.getTrustedCerts();
    }

    private void offer(X509Certificate x509Certificate) throws IOException, CertificateException {
        System.out.print("You don't trust your peer's root cert\n");
        System.out.println("  Issuer: " + x509Certificate.getIssuerDN().getName());
        System.out.println("  Subject: " + x509Certificate.getSubjectDN().getName());
        System.out.print("Either quit the session now or save the\n");
        System.out.println("root cert to add to your trusted certs store\n");
        System.out.print("Enter filename to save root cert: ");
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        FileOutputStream fileOutputStream = new FileOutputStream(bufferedReader.readLine());
        fileOutputStream.write("-----BEGIN CERTIFICATE-----".getBytes());
        Base64OutputStream base64OutputStream = new Base64OutputStream(fileOutputStream);
        base64OutputStream.write(x509Certificate.getEncoded());
        base64OutputStream.flush();
        fileOutputStream.write("-----END CERTIFICATE-----".getBytes());
        fileOutputStream.close();
    }

    public void setTrustedCerts(Vector vector) {
        this.cpb.setTrustedCerts(vector);
    }

    public void verifyCertChain(X509Certificate[] x509CertificateArray) throws CertPathException, CertificateException, IOException {
        this.verifyCertChain(x509CertificateArray, null);
    }

    public void verifyCertChain(X509Certificate[] x509CertificateArray, X509CertChecker x509CertChecker) throws CertPathException, CertificateException, IOException {
        this.cpb.verify(x509CertificateArray, x509CertChecker);
    }
}

