/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Null;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.OID;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AlgorithmId {
    private Asn1 asn1;
    private String oid;
    private AlgorithmParameters params;

    public AlgorithmId(Asn1 asn1) throws Asn1Exception {
        block7: {
            this.oid = null;
            this.params = null;
            try {
                this.asn1 = asn1;
                Iterator iterator = asn1.components();
                this.oid = ((Oid)iterator.next()).getOid();
                if (!iterator.hasNext()) break block7;
                Asn1 asn12 = (Asn1)iterator.next();
                if (asn12 instanceof Null) {
                    this.params = null;
                    return;
                }
                try {
                    String string = OID.getAlgName(this.oid);
                    this.params = AlgorithmParameters.getInstance(string);
                    this.params.init(asn12.getEncoded());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.params = null;
                    return;
                }
                catch (Exception exception) {
                    throw new Asn1Exception(exception.getMessage());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new Asn1Exception("Bad encoding: " + noSuchElementException.getMessage());
            }
            catch (ClassCastException classCastException) {
                throw new Asn1Exception("Bad encoding: " + classCastException.getMessage());
            }
        }
    }

    public AlgorithmId(InputStream inputStream) throws Asn1Exception, IOException {
        this(Asn1.getAsn1(inputStream));
    }

    public AlgorithmId(String string) {
        this.oid = null;
        this.params = null;
        this.asn1 = new Sequence();
        this.oid = string;
        this.asn1.add(new Oid(string));
        this.asn1.add(new Null());
    }

    public AlgorithmId(String string, AlgorithmParameters algorithmParameters) throws Asn1Exception, IOException {
        this.oid = null;
        this.params = null;
        this.asn1 = new Sequence();
        this.oid = string;
        this.asn1.add(new Oid(string));
        this.params = algorithmParameters;
        if (algorithmParameters == null) {
            this.asn1.add(new Null());
        } else {
            this.asn1.add(Asn1.getAsn1(algorithmParameters.getEncoded()));
        }
    }

    public AlgorithmId(String string, boolean bl) {
        this.oid = null;
        this.params = null;
        this.asn1 = new Sequence();
        this.oid = string;
        this.asn1.add(new Oid(string));
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getOid() {
        return this.oid;
    }

    public AlgorithmParameters getParams() {
        return this.params;
    }
}

