/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class Attribute {
    private Asn1 asn1 = null;
    protected String type;
    protected Vector values;

    public Attribute(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.type = ((Oid)iterator.next()).getOid();
        Set set = (Set)iterator.next();
        Iterator iterator2 = set.components();
        this.values = new Vector();
        while (iterator2.hasNext()) {
            this.values.add((Asn1)iterator2.next());
        }
    }

    public Attribute(String string, Asn1 asn1) {
        this.asn1 = new Sequence();
        this.values = new Vector();
        this.values.add(asn1);
        this.type = string;
        this.asn1.add(new Oid(string));
        Set set = new Set();
        set.add(asn1);
        this.asn1.add(set);
    }

    public Attribute(String string, Vector vector) {
        this.asn1 = new Sequence();
        this.type = string;
        this.asn1.add(new Oid(string));
        this.values = vector;
        Set set = new Set();
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            set.add((Asn1)iterator.next());
        }
        this.asn1.add(set);
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getType() {
        return this.type;
    }

    public Vector getValues() {
        return this.values;
    }
}

