/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import java.util.Iterator;

public class ContentInfo {
    private Asn1 asn1 = null;
    private Oid contentType;
    private Asn1 content = null;

    public ContentInfo(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null data");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.contentType = (Oid)iterator.next();
        if (!iterator.hasNext()) {
            return;
        }
        Asn1 asn12 = (Asn1)iterator.next();
        this.content = asn12.components() == null ? asn12 : (Asn1)asn12.components().next();
    }

    public ContentInfo(String string, Asn1 asn1) {
        this.asn1 = new Sequence();
        this.contentType = new Oid(string);
        this.asn1.add(this.contentType);
        if (asn1 != null) {
            this.content = asn1;
            Explicit explicit = new Explicit(128, 0);
            explicit.add(asn1);
            this.asn1.add(explicit);
        }
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public Asn1 getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType.getOid();
    }
}

