/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class PrivateKeyInfo {
    private Asn1 asn1 = null;
    private int version = 0;
    private byte[] encodedKey;
    private AlgorithmId privAlgo;

    public PrivateKeyInfo(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.version = ((Integer)iterator.next()).getInt();
        this.privAlgo = new AlgorithmId((Asn1)iterator.next());
        this.encodedKey = ((OctetString)iterator.next()).getBytes();
    }

    public PrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray) {
        this.asn1 = new Sequence();
        this.asn1.add(new Integer(this.version));
        this.privAlgo = algorithmId;
        this.asn1.add(algorithmId.getAsn1());
        this.encodedKey = byArray;
        this.asn1.add(new OctetString(byArray));
    }

    public PrivateKeyInfo(InputStream inputStream) throws Asn1Exception, IOException {
        this(Asn1.getAsn1(inputStream));
    }

    public PrivateKeyInfo(byte[] byArray) throws Asn1Exception {
        this(Asn1.getAsn1(byArray));
    }

    public AlgorithmId getAlgorithmId() {
        return this.privAlgo;
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getEncodedKey() {
        return this.encodedKey;
    }
}

