/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class SubjectPublicKeyInfo {
    private Asn1 asn1 = null;
    private AlgorithmId algoId;
    private byte[] encodedKey;

    public SubjectPublicKeyInfo(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.algoId = new AlgorithmId((Asn1)iterator.next());
        this.encodedKey = ((BitString)iterator.next()).getBytes();
    }

    public SubjectPublicKeyInfo(AlgorithmId algorithmId, byte[] byArray) {
        this.asn1 = new Sequence();
        this.algoId = algorithmId;
        this.asn1.add(algorithmId.getAsn1());
        this.encodedKey = byArray;
        this.asn1.add(new BitString(byArray));
    }

    public SubjectPublicKeyInfo(InputStream inputStream) throws Asn1Exception, IOException {
        this(Asn1.getAsn1(inputStream));
    }

    public SubjectPublicKeyInfo(byte[] byArray) throws Asn1Exception {
        this(Asn1.getAsn1(byArray));
    }

    public AlgorithmId getAlgorithmId() {
        return this.algoId;
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getEncoded() {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            return null;
        }
    }

    public byte[] getEncodedKey() {
        return this.encodedKey;
    }
}

