/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.common;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.RDN;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class X500Name
implements Principal {
    private Asn1 asn1 = null;
    private Vector rdns = new Vector();

    public X500Name(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 == null) break;
            this.rdns.add(0, new RDN(asn12));
        }
    }

    public X500Name(InputStream inputStream) throws Asn1Exception, IOException {
        this(Asn1.getAsn1(inputStream));
    }

    public X500Name(String string) {
        RDN rDN;
        this.asn1 = new Sequence();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String string2 = stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = this.dequote(stringTokenizer.nextToken());
            if (string2.indexOf(61) == -1) {
                stringBuffer.append(",").append(string2);
                continue;
            }
            rDN = new RDN(stringBuffer.toString());
            this.rdns.add(rDN);
            stringBuffer = new StringBuffer(string2);
        }
        rDN = new RDN(stringBuffer.toString());
        this.rdns.add(rDN);
        int n = this.rdns.size();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.asn1.add(((RDN)this.rdns.elementAt(n2)).getAsn1());
            --n2;
        }
    }

    public X500Name(byte[] byArray) throws Asn1Exception {
        this(Asn1.getAsn1(byArray));
    }

    private String dequote(String string) {
        int n = string.indexOf("\"");
        if (n == -1) {
            return string;
        }
        return String.valueOf(string.substring(0, n)) + string.substring(n + 1, string.length());
    }

    public boolean equals(Object object) {
        try {
            return X500Name.equals(this, (Principal)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static boolean equals(Principal principal, Principal principal2) {
        if (principal == principal2) {
            return true;
        }
        if (principal == null || principal2 == null) {
            return false;
        }
        return principal.getName().equals(principal2.getName());
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.rdns).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((RDN)iterator.next()).getName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public Vector getRDNs() {
        return this.rdns;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

