/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.common.PrivateKeyInfo;
import com.dstc.security.keymanage.PKCS8Exception;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS8EncryptedPrivateKey {
    private Asn1 asn1 = null;
    private String alg = "1.2.840.113549.1.5.3";
    private AlgorithmId algoId = null;
    private byte[] encKeyBytes = null;
    private PrivateKey priv = null;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;

    public PKCS8EncryptedPrivateKey(InputStream inputStream) throws PKCS8Exception, IOException {
        this.decode(Asn1.getAsn1(inputStream));
    }

    public PKCS8EncryptedPrivateKey(PrivateKey privateKey) {
        this.priv = privateKey;
    }

    public PKCS8EncryptedPrivateKey(PrivateKey privateKey, String string) {
        this.priv = privateKey;
        this.alg = string;
    }

    public PKCS8EncryptedPrivateKey(byte[] byArray) throws PKCS8Exception {
        try {
            this.decode(Asn1.getAsn1(byArray));
        }
        catch (Asn1Exception asn1Exception) {
            throw new PKCS8Exception("Bad pkcs8 encoding: " + asn1Exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void decode(Asn1 asn1) throws PKCS8Exception {
        try {
            this.asn1 = asn1;
            Iterator iterator = asn1.components();
            this.algoId = new AlgorithmId((Asn1)iterator.next());
            this.alg = this.algoId.getOid();
            this.encKeyBytes = ((OctetString)iterator.next()).getBytes();
        }
        catch (Asn1Exception asn1Exception) {
            throw new PKCS8Exception("Bad pkcs8 encoding: " + asn1Exception.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new PKCS8Exception("Bad pkcs8 encoding: " + classCastException.getMessage());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new PKCS8Exception("Bad pkcs8 encoding");
        }
    }

    public void decrypt(PBEKeySpec pBEKeySpec) throws PKCS8Exception {
        Object object;
        Object object2;
        Cipher cipher = null;
        SecretKeyFactory secretKeyFactory = null;
        byte[] byArray = null;
        try {
            cipher = Cipher.getInstance(OID.getAlgName(this.alg));
            secretKeyFactory = SecretKeyFactory.getInstance(OID.getAlgName(this.alg));
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException(noSuchPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        try {
            object2 = (PBEParameterSpec)this.algoId.getParams().getParameterSpec(class$javax$crypto$spec$PBEParameterSpec != null ? class$javax$crypto$spec$PBEParameterSpec : (class$javax$crypto$spec$PBEParameterSpec = PKCS8EncryptedPrivateKey.class$("javax.crypto.spec.PBEParameterSpec")));
            object = secretKeyFactory.generateSecret(pBEKeySpec);
            cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2, null);
            byArray = cipher.doFinal(this.encKeyBytes);
        }
        catch (BadPaddingException badPaddingException) {
            throw new PKCS8Exception("Invalid password");
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.toString());
        }
        try {
            object2 = new PrivateKeyInfo(byArray);
            object = ((PrivateKeyInfo)object2).getAlgorithmId();
            KeyFactory keyFactory = null;
            if (((AlgorithmId)object).getOid().equals("1.2.840.113549.1.1.1")) {
                keyFactory = KeyFactory.getInstance("RSA");
            } else if (((AlgorithmId)object).getOid().equals("1.2.840.10040.4.1")) {
                keyFactory = KeyFactory.getInstance("DSA");
            } else if (((AlgorithmId)object).getOid().equals("1.2.840.113549.1.3.1")) {
                keyFactory = KeyFactory.getInstance("DH");
            }
            this.priv = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("Internal error: " + invalidKeySpecException.getMessage());
        }
        catch (Asn1Exception asn1Exception) {
            throw new PKCS8Exception("Bad encoding or bad password: " + asn1Exception.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCS8Exception("Algorithm not supported: " + noSuchAlgorithmException.getMessage());
        }
    }

    public void decrypt(char[] cArray) throws PKCS8Exception {
        this.decrypt(new PBEKeySpec(cArray));
    }

    private void encode() throws IOException {
        this.asn1 = new Sequence();
        this.asn1.add(this.algoId.getAsn1());
        this.asn1.add(new OctetString(this.encKeyBytes));
    }

    public void encrypt(PBEKeySpec pBEKeySpec) throws PKCS8Exception {
        Object object;
        AlgorithmParameters algorithmParameters = null;
        String string = null;
        SecretKeyFactory secretKeyFactory = null;
        Cipher cipher = null;
        PBEParameterSpec pBEParameterSpec = null;
        try {
            string = OID.getAlgName(this.alg);
            if (string == null) {
                throw new PKCS8Exception("PBE algorithm " + this.alg + " unsupported");
            }
            secretKeyFactory = SecretKeyFactory.getInstance(string);
            object = secretKeyFactory.generateSecret(pBEKeySpec);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(object.getEncoded());
            byte[] byArray = messageDigest.digest(this.priv.getEncoded());
            byte[] byArray2 = new byte[8];
            System.arraycopy(byArray, 0, byArray2, 0, 8);
            pBEParameterSpec = new PBEParameterSpec(byArray2, 5);
            algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(pBEParameterSpec);
            cipher = Cipher.getInstance(string);
            cipher.init(1, (Key)object, pBEParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCS8Exception("Provider error: " + noSuchAlgorithmException.getMessage());
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
        try {
            object = this.priv.getEncoded();
            this.encKeyBytes = cipher.doFinal((byte[])object);
            this.algoId = new AlgorithmId(this.alg, algorithmParameters);
            this.encode();
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.getMessage());
        }
    }

    public void encrypt(char[] cArray) throws PKCS8Exception {
        this.encrypt(new PBEKeySpec(cArray));
    }

    public byte[] getEncoded() throws PKCS8Exception {
        if (this.asn1 == null) {
            throw new PKCS8Exception("Private key not yet encrypted");
        }
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException("Internal error: " + asn1Exception.getMessage());
        }
    }

    public PrivateKey getPrivateKey() throws PKCS8Exception {
        if (this.priv == null) {
            throw new PKCS8Exception("Private key not yet decrypted");
        }
        return this.priv;
    }
}

