/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.common.PrivateKeyInfo;
import com.dstc.security.keymanage.SSLeayException;
import com.dstc.security.util.Base64InputStream;
import com.dstc.security.util.Base64OutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SSLeayEncryptedPrivateKey {
    private static final byte[] HEADER = "-----BEGIN RSA PRIVATE KEY-----\nProc-Type: 4,ENCRYPTED\nDEK-Info: DES-EDE3-CBC,".getBytes();
    private static final byte[] FOOTER = "\n-----END RSA PRIVATE KEY-----".getBytes();
    private String keyAlg;
    private IvParameterSpec iv;
    private Cipher ciph;
    private String encAlg = "DESede";
    private byte[] encodedKey;
    private PrivateKey priv;
    private SecureRandom rand = null;

    public SSLeayEncryptedPrivateKey(InputStream inputStream) throws SSLeayException, IOException {
        this.decode(inputStream);
    }

    public SSLeayEncryptedPrivateKey(SecureRandom secureRandom, PrivateKey privateKey) throws SSLeayException {
        if (!(privateKey instanceof RSAPrivateCrtKey)) {
            throw new SSLeayException("Only RSA CRT Private Key supported");
        }
        this.rand = secureRandom;
        this.priv = privateKey;
    }

    public SSLeayEncryptedPrivateKey(byte[] byArray) throws SSLeayException {
        try {
            this.decode(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new SSLeayException("Unexpected error");
        }
    }

    private static KeySpec asn1ToPriv(byte[] byArray) throws Asn1Exception {
        try {
            Asn1 asn1 = Asn1.getAsn1(byArray);
            Iterator iterator = asn1.components();
            if (((com.dstc.security.asn1.Integer)iterator.next()).getInt() != 0) {
                throw new Asn1Exception("Bad asn1 encoding");
            }
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger(), ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger(), ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger(), ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger(), ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger(), ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger(), ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger(), ((com.dstc.security.asn1.Integer)iterator.next()).getBigInteger());
            return rSAPrivateCrtKeySpec;
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Bad asn1 encoding: " + classCastException.getMessage());
        }
    }

    private void checkAlg(String string) throws SSLeayException {
        if (!string.startsWith("-----BEGIN")) {
            throw new SSLeayException("Not an SSLeay protected private key");
        }
        if (string.indexOf("RSA") == -1) {
            throw new SSLeayException("Only RSA keys supported");
        }
        this.keyAlg = "RSA";
    }

    private void checkEncrypted(String string) throws SSLeayException {
        try {
            String string2 = string.substring(10);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
            if (!stringTokenizer.nextToken().equals("DES-EDE3-CBC")) {
                throw new SSLeayException("Only DESede encryption supported");
            }
            this.encAlg = "DESede";
            this.ciph = Cipher.getInstance(String.valueOf(this.encAlg) + "/CBC/PKCS5Padding");
            this.retrieveIV(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new SSLeayException("Unexpected error: " + exception.getMessage());
        }
    }

    private void decode(InputStream inputStream) throws IOException, SSLeayException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = bufferedReader.readLine();
        this.checkAlg(string);
        string = bufferedReader.readLine();
        if (!string.startsWith("Proc-Type: 4,ENCRYPTED")) {
            throw new SSLeayException("Not an encrypted private key");
        }
        this.checkEncrypted(bufferedReader.readLine());
        bufferedReader.readLine();
        while (true) {
            if ((string = bufferedReader.readLine()).startsWith("-----END")) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((string = bufferedReader.readLine()) != null) {
                    byteArrayOutputStream.write((String.valueOf(string) + "\n").getBytes());
                }
                break;
            }
            stringBuffer.append(string).append("\n");
        }
        inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        this.encodedKey = stringBuffer.toString().getBytes();
    }

    public void decrypt(char[] cArray) throws SSLeayException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encodedKey);
            Base64InputStream base64InputStream = new Base64InputStream(byteArrayInputStream);
            byte[] byArray = new byte[base64InputStream.available()];
            int n = base64InputStream.read(byArray);
            this.ciph.init(2, (Key)this.passToKey(cArray), this.iv);
            byte[] byArray2 = this.ciph.doFinal(byArray, 0, n);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.priv = keyFactory.generatePrivate(SSLeayEncryptedPrivateKey.asn1ToPriv(byArray2));
        }
        catch (BadPaddingException badPaddingException) {
            throw new SSLeayException("Bad password");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLeayException("Provider error: " + noSuchAlgorithmException.getMessage());
        }
        catch (Exception exception) {
            throw new SSLeayException("Unexpected error: " + exception.getMessage());
        }
    }

    public void encrypt(char[] cArray) throws SSLeayException {
        try {
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(this.priv.getEncoded());
            byte[] byArray = privateKeyInfo.getEncodedKey();
            this.ciph = Cipher.getInstance(String.valueOf(this.encAlg) + "/CBC/PKCS5Padding");
            byte[] byArray2 = new byte[8];
            if (this.rand == null) {
                this.rand = new SecureRandom();
            }
            this.rand.nextBytes(byArray2);
            this.iv = new IvParameterSpec(byArray2);
            this.ciph.init(1, (Key)this.passToKey(cArray), this.iv);
            byte[] byArray3 = this.ciph.doFinal(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Base64OutputStream base64OutputStream = new Base64OutputStream(0, 15, byteArrayOutputStream);
            base64OutputStream.write(byArray3);
            base64OutputStream.close();
            this.encodedKey = byteArrayOutputStream.toByteArray();
        }
        catch (Asn1Exception asn1Exception) {
            throw new SSLeayException("Unexpected error: " + asn1Exception.getMessage());
        }
        catch (IOException iOException) {
            throw new SSLeayException("Unexpected error: " + iOException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLeayException("Provider error: " + noSuchAlgorithmException.getMessage());
        }
        catch (Exception exception) {
            throw new SSLeayException("Unexpected error: " + exception.getMessage());
        }
    }

    public byte[] getEncoded() throws SSLeayException {
        if (this.encodedKey == null) {
            throw new SSLeayException("Private key not yet encrypted");
        }
        byte[] byArray = this.ivToString().getBytes();
        byte[] byArray2 = new byte[HEADER.length + byArray.length + FOOTER.length + this.encodedKey.length];
        System.arraycopy(HEADER, 0, byArray2, 0, HEADER.length);
        System.arraycopy(byArray, 0, byArray2, HEADER.length, byArray.length);
        System.arraycopy(this.encodedKey, 0, byArray2, HEADER.length + byArray.length, this.encodedKey.length);
        System.arraycopy(FOOTER, 0, byArray2, HEADER.length + this.encodedKey.length + byArray.length, FOOTER.length);
        return byArray2;
    }

    public PrivateKey getPrivateKey() throws SSLeayException {
        if (this.priv == null) {
            throw new SSLeayException("Private key not yet decrypted");
        }
        return this.priv;
    }

    private static final String hexDigit(byte by) {
        char[] cArray = new char[2];
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[0] = c;
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[1] = c;
        return new String(cArray);
    }

    private String ivToString() {
        byte[] byArray = this.iv.getIV();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(SSLeayEncryptedPrivateKey.hexDigit(byArray[n]));
            ++n;
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    private SecretKey passToKey(char[] cArray) throws SSLeayException {
        try {
            byte[] byArray = new byte[24];
            byte[] byArray2 = new String(cArray).getBytes();
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray2);
            messageDigest.update(this.iv.getIV());
            byte[] byArray3 = messageDigest.digest();
            System.arraycopy(byArray3, 0, byArray, 0, 16);
            messageDigest.update(byArray3);
            messageDigest.update(byArray2);
            messageDigest.update(this.iv.getIV());
            byArray3 = messageDigest.digest();
            System.arraycopy(byArray3, 0, byArray, 16, 8);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.encAlg);
            return secretKeySpec;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLeayException("Provider error: " + noSuchAlgorithmException.getMessage());
        }
    }

    private void retrieveIV(String string) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)Integer.parseInt(string.substring(n * 2, n * 2 + 2), 16);
            ++n;
        }
        this.iv = new IvParameterSpec(byArray);
    }
}

