/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.debug;

import com.dstc.security.asn1.Asn1;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Debug {
    public static final int NONE = 1000;
    public static final int EMERGENCY = 8;
    public static final int ALERT = 7;
    public static final int CRITICAL = 6;
    public static final int ERROR = 5;
    public static final int WARNING = 4;
    public static final int NOTICE = 3;
    public static final int INFO = 2;
    public static final int DEBUG = 1;
    public static final int ALL = 0;
    public static final String AUTHENTICATEDSAFE = "authenticatedsafe";
    public static final String MACDATA = "macdata";
    public static final String PFX = "pfx";
    public static final String SAFEBAG = "safebag";
    public static final String SAFECONTENTS = "safecontents";
    public static final String CERTBAG = "certbag";
    public static final String KEYBAG = "keybag";
    public static final String SHROUDEDKEYBAG = "shroudedkeybag";
    public static final String UNKNOWNBAG = "unknownbag";
    public static final String CERT = "cert";
    public static final String SAFEBAG_W_CERTBAG = "safebagWcertbag";
    private static PrintStream debug = System.err;
    private static int debugLevel = 1000;
    private static int dumpLevel = 1000;
    private static final String tmpdir = System.getProperty("java.io.tmpdir");
    private static String dumpDirName = "key_manage_dump";
    private static final String POSTFIX = ".asn1";
    private static File dumpDir;

    public static void dumpAsn1To(Asn1 asn1, String string) {
        block5: {
            if (!Debug.shouldDump(1)) break block5;
            if (dumpDir == null) {
                try {
                    dumpDir = new File(String.valueOf(tmpdir) + File.separator + Debug.getDumpDirName());
                    dumpDir.mkdirs();
                }
                catch (Exception exception) {
                    Debug.log(5, "Debug.dumpAsn1To", exception.toString());
                    return;
                }
            }
            Debug.log(2, "Debug.dumpAsn1To()", "Dumping ASN.1 encoded object to: " + string);
            try {
                File file = File.createTempFile(string, POSTFIX, dumpDir);
                byte[] byArray = asn1.getEncoded();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                Debug.log(5, "Debug.dumpAsn1To", exception.toString());
            }
        }
    }

    public static String getDumpDirName() {
        return dumpDirName;
    }

    public static void log(int n, String string, String string2) {
        if (Debug.shouldDebug(n)) {
            debug.print(String.valueOf(string) + ": ");
            debug.println(string2);
        }
    }

    public static void setDebugLevel(int n) {
        debugLevel = n;
    }

    public static void setDebugStream(PrintStream printStream) {
        debug = printStream;
    }

    public static void setDumpDirName(String string) {
        dumpDirName = string;
        dumpDir = null;
    }

    public static void setDumpLevel(int n) {
        dumpLevel = n;
    }

    public static boolean shouldDebug(int n) {
        return n >= debugLevel;
    }

    public static boolean shouldDump(int n) {
        boolean bl = n >= dumpLevel;
        return bl;
    }
}

