/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs12;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs12.SafeContents;
import com.dstc.security.keymanage.pkcs7.ContentInfo;
import com.dstc.security.keymanage.pkcs7.ContentInfoFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class AuthenticatedSafe {
    private Asn1 asn1;
    private Vector contents = new Vector();

    public AuthenticatedSafe() {
    }

    public AuthenticatedSafe(Asn1 asn1) throws Asn1Exception {
        Debug.log(1, "AuthenticatedSafe( Asn1 )", "");
        Debug.dumpAsn1To(asn1, "authenticatedsafe");
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = null;
        ContentInfo contentInfo = null;
        while (iterator.hasNext()) {
            asn12 = (Asn1)iterator.next();
            contentInfo = new ContentInfo(asn12);
            this.contents.add(contentInfo);
        }
    }

    public AuthenticatedSafe(SafeContents safeContents) {
        this.add(safeContents);
    }

    public AuthenticatedSafe(ContentInfo[] contentInfoArray) {
        int n = 0;
        while (n < contentInfoArray.length) {
            this.contents.add(contentInfoArray[n]);
            ++n;
        }
    }

    public void add(int n, SafeContents safeContents) {
        this.asn1 = null;
        Asn1 asn1 = safeContents.getAsn1();
        ContentInfo contentInfo = ContentInfoFactory.createContentInfo(asn1);
        this.add(n, contentInfo);
    }

    public void add(int n, ContentInfo contentInfo) {
        this.asn1 = null;
        this.contents.add(n, contentInfo);
    }

    public void add(SafeContents safeContents) {
        this.asn1 = null;
        Asn1 asn1 = safeContents.getAsn1();
        ContentInfo contentInfo = ContentInfoFactory.createContentInfo(asn1);
        this.add(contentInfo);
    }

    public void add(ContentInfo contentInfo) {
        this.asn1 = null;
        this.contents.add(contentInfo);
    }

    public ContentInfo get(int n) {
        return (ContentInfo)this.contents.get(n);
    }

    public Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.asn1 = new Sequence();
            int n = this.contents.size();
            int n2 = 0;
            while (n2 < n) {
                ContentInfo contentInfo = (ContentInfo)this.contents.get(n2);
                this.asn1.add(contentInfo.getAsn1());
                ++n2;
            }
        }
        return this.asn1;
    }

    public ContentInfo[] getContents() {
        ContentInfo[] contentInfoArray = new ContentInfo[this.contents.size()];
        this.contents.toArray(contentInfoArray);
        return contentInfoArray;
    }

    public ContentInfo remove(int n) {
        this.asn1 = null;
        return (ContentInfo)this.contents.remove(n);
    }

    public ContentInfo remove(ContentInfo contentInfo) throws NoSuchElementException {
        this.asn1 = null;
        if (!this.contents.remove(contentInfo)) {
            throw new NoSuchElementException("ContentInfo not present");
        }
        return contentInfo;
    }
}

