/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs12;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs7.DigestInfo;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MacData {
    private Asn1 asn1;
    private DigestInfo mac;
    private byte[] macSalt;
    private int iterations = 1;
    private boolean explicit;

    public MacData(Asn1 asn1) throws Asn1Exception {
        Debug.log(1, "MacData( Asn1 )", "");
        Debug.dumpAsn1To(asn1, "macdata");
        try {
            Iterator iterator = asn1.components();
            Sequence sequence = (Sequence)iterator.next();
            this.mac = new DigestInfo(sequence);
            OctetString octetString = (OctetString)iterator.next();
            this.macSalt = octetString.getBytes();
            if (iterator.hasNext()) {
                Integer integer = (Integer)iterator.next();
                this.iterations = integer.getInt();
                this.explicit = true;
            }
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Incomplete MacData ASN.1");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Incomplete MacData ASN.1");
        }
    }

    public MacData(DigestInfo digestInfo, byte[] byArray, int n) {
        this(digestInfo, byArray, n, true);
    }

    public MacData(DigestInfo digestInfo, byte[] byArray, int n, boolean bl) {
        this.mac = digestInfo;
        this.macSalt = byArray;
        this.iterations = n;
        this.explicit = bl;
    }

    public Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.asn1 = new Sequence();
            this.asn1.add(this.mac.getAsn1());
            this.asn1.add(new OctetString(this.macSalt));
            if (this.explicit || this.iterations != 1) {
                this.asn1.add(new Integer(this.iterations));
            }
        }
        return this.asn1;
    }

    public int getIterations() {
        return this.iterations;
    }

    public DigestInfo getMac() {
        return this.mac;
    }

    public byte[] getMacSalt() {
        return this.macSalt;
    }
}

