/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs12;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1DecodingException;
import com.dstc.security.asn1.Asn1EncodingException;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs12.AuthenticatedSafe;
import com.dstc.security.keymanage.pkcs12.InvalidFlagException;
import com.dstc.security.keymanage.pkcs12.MacData;
import com.dstc.security.keymanage.pkcs7.AlgorithmId;
import com.dstc.security.keymanage.pkcs7.ContentInfo;
import com.dstc.security.keymanage.pkcs7.ContentInfoFactory;
import com.dstc.security.keymanage.pkcs7.DigestInfo;
import com.dstc.security.keymanage.util.PKCS12KeyFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;

public class PFX {
    private Asn1 asn1;
    private int version = 3;
    private ContentInfo contentInfo;
    private MacData macData;
    private AuthenticatedSafe authSafe;
    private byte[] data;
    private byte[] test_data;
    private static final int DEFAULT_VERSION = 3;
    public static final int DEFAULT = 0;
    public static final int NETSCAPE_COMPATIBLE = 1;
    public static final int MICROSOFT_COMPATIBLE = 2;
    private static final int GREATEST_FLAG = 2;
    private static final int COM_ITERATIONS = 1;
    private static final int DEFAULT_ITERATIONS = 1;

    public PFX(Asn1 asn1) throws Asn1Exception {
        Debug.log(1, "PFX( Asn1 )", "");
        Debug.dumpAsn1To(asn1, "pfx");
        Iterator iterator = asn1.components();
        try {
            com.dstc.security.asn1.Integer integer = (com.dstc.security.asn1.Integer)iterator.next();
            this.version = integer.getInt();
            Asn1 asn12 = (Asn1)iterator.next();
            this.contentInfo = new ContentInfo(asn12);
            this.initDataAndAuthSafe();
            if (iterator.hasNext()) {
                Asn1 asn13 = (Asn1)iterator.next();
                Debug.log(1, "PFX( Asn1 )", "Returned MacData");
                this.macData = new MacData(asn13);
            }
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid PFX ASN.1: " + classCastException.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Incomplete PFX ASN.1: " + noSuchElementException.toString());
        }
    }

    public PFX(AuthenticatedSafe authenticatedSafe) {
        this(authenticatedSafe, null);
        Debug.log(1, "PFX( AuthenticatedSafe )", "");
    }

    public PFX(AuthenticatedSafe authenticatedSafe, MacData macData) {
        this.version = 3;
        this.authSafe = authenticatedSafe;
        Asn1 asn1 = authenticatedSafe.getAsn1();
        this.contentInfo = ContentInfoFactory.createContentInfo(asn1);
        try {
            this.data = asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            Debug.log(5, "PFX( AuthenticatedSafe, MacData )", "Unexpected exception while encoding AuthenticatedSafe");
            throw new RuntimeException("Unexpected exception while encoding AuthenticatedSafe: " + asn1Exception.toString());
        }
        if (macData != null) {
            this.macData = macData;
        }
    }

    public PFX(ContentInfo contentInfo) throws Asn1Exception {
        this(contentInfo, null);
        Debug.log(1, "PFX( ContentInfo )", "");
    }

    public PFX(ContentInfo contentInfo, MacData macData) throws Asn1DecodingException, Asn1Exception {
        Debug.log(1, "PFX( ContentInfo, MacData )", "");
        this.version = 3;
        this.contentInfo = contentInfo;
        this.macData = macData;
        this.initDataAndAuthSafe();
    }

    private static byte[] computeMac(byte[] byArray, SecretKey secretKey) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = null;
        try {
            mac = Mac.getInstance("HMACwithSHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Debug.log(6, "PFXFactory.macPFX()", noSuchAlgorithmException.toString());
            Debug.log(6, "PFXFactory.macPFX()", "Check that JCE is installed correctly");
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        mac.init(secretKey);
        return mac.doFinal(byArray);
    }

    public static PFX createPFX(InputStream inputStream) throws Asn1DecodingException, Asn1Exception, IOException {
        Debug.log(1, "PFX.createPFX( InputStream )", "");
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        Asn1 asn1 = Asn1.getAsn1(byArray);
        return new PFX(asn1);
    }

    public void encode(OutputStream outputStream) throws Asn1EncodingException, IOException {
        try {
            Asn1 asn1 = this.getAsn1();
            asn1.derEncode(outputStream);
        }
        catch (Asn1Exception asn1Exception) {
            throw new Asn1EncodingException();
        }
    }

    public Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.asn1 = new Sequence();
            this.asn1.add(new com.dstc.security.asn1.Integer(this.version));
            this.asn1.add(this.contentInfo.getAsn1());
            if (this.macData != null) {
                this.asn1.add(this.macData.getAsn1());
            }
        }
        return this.asn1;
    }

    public AuthenticatedSafe getAuthSafe() {
        return this.authSafe;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    private byte[] getData() {
        return this.data;
    }

    public MacData getMacData() throws NoSuchElementException {
        if (this.macData == null) {
            throw new NoSuchElementException("Optional MacData Not Present");
        }
        return this.macData;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean hasMacData() {
        return this.macData != null;
    }

    private void initDataAndAuthSafe() throws Asn1DecodingException, Asn1Exception {
        Debug.log(1, "PFX.initDataAndAuthSafe()", "");
        try {
            this.data = ContentInfoFactory.recurse(this.contentInfo, null, null);
        }
        catch (Asn1Exception asn1Exception) {
            throw asn1Exception;
        }
        catch (Exception exception) {
            throw new Asn1Exception("Content does not contain Data or SignedData as expected");
        }
        Asn1 asn1 = Asn1.getAsn1(this.data);
        this.authSafe = new AuthenticatedSafe(asn1);
    }

    public void mac(SecretKey secretKey) throws InvalidKeyException {
        try {
            this.mac(secretKey, 0);
        }
        catch (InvalidFlagException invalidFlagException) {
            throw new RuntimeException(invalidFlagException.toString());
        }
    }

    public void mac(SecretKey secretKey, int n) throws InvalidFlagException, InvalidKeyException {
        PBEParameterSpec pBEParameterSpec = null;
        if (n == 0) {
            pBEParameterSpec = PKCS12KeyFactory.generatePBEParameterSpec();
        } else {
            byte[] byArray = PKCS12KeyFactory.generateSalt();
            pBEParameterSpec = new PBEParameterSpec(byArray, 1);
        }
        this.mac(secretKey, pBEParameterSpec, n);
    }

    public void mac(SecretKey secretKey, PBEParameterSpec pBEParameterSpec) throws InvalidKeyException {
        try {
            this.mac(secretKey, pBEParameterSpec, 0);
        }
        catch (InvalidFlagException invalidFlagException) {
            throw new RuntimeException(invalidFlagException.toString());
        }
    }

    public void mac(SecretKey secretKey, PBEParameterSpec pBEParameterSpec, int n) throws InvalidKeyException, InvalidFlagException {
        PBEParameterSpec pBEParameterSpec2 = null;
        if (n < 0 || n > 2) {
            String string = Integer.toString(n);
            throw new InvalidFlagException("Invalid Flag Value: " + string);
        }
        pBEParameterSpec2 = n == 1 || n == 2 ? new PBEParameterSpec(pBEParameterSpec.getSalt(), 1) : pBEParameterSpec;
        SecretKey secretKey2 = PKCS12KeyFactory.generateMacKey(secretKey, pBEParameterSpec2);
        byte[] byArray = this.getData();
        byte[] byArray2 = null;
        try {
            byArray2 = PFX.computeMac(byArray, secretKey2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Debug.log(6, "PFXFactory.macPFX()", noSuchAlgorithmException.toString());
            Debug.log(6, "PFXFactory.macPFX()", "Check that JCE is installed correctly");
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        AlgorithmId algorithmId = new AlgorithmId("1.3.14.3.2.26");
        DigestInfo digestInfo = new DigestInfo(algorithmId, byArray2);
        byte[] byArray3 = pBEParameterSpec2.getSalt();
        int n2 = pBEParameterSpec2.getIterationCount();
        this.macData = n == 2 ? new MacData(digestInfo, byArray3, n2, true) : new MacData(digestInfo, byArray3, n2);
    }

    public boolean verify(SecretKey secretKey) throws InvalidKeyException, NoSuchAlgorithmException {
        Object object;
        byte[] byArray = this.getData();
        try {
            object = this.getMacData();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        object = this.macData.getMac();
        byte[] byArray2 = ((DigestInfo)object).getDigest();
        byte[] byArray3 = this.macData.getMacSalt();
        int n = this.macData.getIterations();
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray3, n);
        SecretKey secretKey2 = PKCS12KeyFactory.generateMacKey(secretKey, pBEParameterSpec);
        byte[] byArray4 = PFX.computeMac(byArray, secretKey2);
        return Arrays.equals(byArray4, byArray2);
    }
}

