/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs12;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.PKCS8Exception;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs12.SafeBag;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SafeContents {
    private Asn1 asn1 = null;
    private Vector safeBags = new Vector();

    public SafeContents() {
    }

    public SafeContents(Asn1 asn1) throws PKCS8Exception, Asn1Exception {
        Debug.dumpAsn1To(asn1, "safecontents");
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        while (iterator.hasNext()) {
            try {
                Sequence sequence = (Sequence)iterator.next();
                this.safeBags.add(new SafeBag(sequence));
            }
            catch (ClassCastException classCastException) {
                throw new Asn1Exception("Invalid SafeBag ASN.1");
            }
        }
    }

    public SafeContents(SafeBag[] safeBagArray) {
        int n = 0;
        while (n < safeBagArray.length) {
            this.safeBags.add(safeBagArray[n]);
            ++n;
        }
    }

    public void add(int n, SafeBag safeBag) throws IndexOutOfBoundsException {
        this.asn1 = null;
        this.safeBags.add(n, safeBag);
    }

    public void add(SafeBag safeBag) {
        this.asn1 = null;
        this.safeBags.add(safeBag);
    }

    public SafeBag[] getAllSafeBags() {
        Object[] objectArray = new SafeBag[this.safeBags.size()];
        this.safeBags.copyInto(objectArray);
        return objectArray;
    }

    public Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.asn1 = new Sequence();
            Iterator iterator = ((AbstractList)this.safeBags).iterator();
            while (iterator.hasNext()) {
                SafeBag safeBag = (SafeBag)iterator.next();
                this.asn1.add(safeBag.getAsn1());
            }
        }
        return this.asn1;
    }

    public String[] getFriendlyNames() {
        int n = this.safeBags.size();
        String[] stringArray = new String[n];
        SafeBag safeBag = null;
        int n2 = 0;
        while (n2 < n) {
            safeBag = (SafeBag)this.safeBags.get(n2);
            stringArray[n2] = safeBag.getFriendlyName();
            ++n2;
        }
        return stringArray;
    }

    public String[] getSafeBagIds() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = ((AbstractList)this.safeBags).iterator();
        while (iterator.hasNext()) {
            object = (SafeBag)iterator.next();
            hashSet.add(((SafeBag)object).getBagId());
        }
        object = new String[hashSet.size()];
        object = ((AbstractCollection)hashSet).toArray((T[])object);
        return object;
    }

    public SafeBag[] getSafeBags(String string) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = ((AbstractList)this.safeBags).iterator();
        while (iterator.hasNext()) {
            object = (SafeBag)iterator.next();
            if (!((SafeBag)object).getFriendlyName().equals(string)) continue;
            vector.add(object);
        }
        object = new SafeBag[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public SafeBag remove(int n) throws IndexOutOfBoundsException {
        this.asn1 = null;
        return (SafeBag)this.safeBags.remove(n);
    }

    public SafeBag[] removeSafeBags(String string) {
        SafeBag[] safeBagArray = this.getSafeBags(string);
        if (safeBagArray.length > 0) {
            this.asn1 = null;
            int n = 0;
            while (n < safeBagArray.length) {
                this.safeBags.remove(safeBagArray[n]);
                ++n;
            }
        }
        return safeBagArray;
    }

    public int size() {
        return this.safeBags.size();
    }
}

