/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs12.bags;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.keymanage.PKCS8EncryptedPrivateKey;
import com.dstc.security.keymanage.PKCS8Exception;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs12.bags.Bag;
import java.util.Iterator;

public class ShroudedKeyBag
implements Bag {
    public static final String SHROUDED_KEYBAG = "1.2.840.113549.1.12.10.1.2";
    private Asn1 asn1;
    private PKCS8EncryptedPrivateKey encryptedPrivateKeyInfo;
    private String encryptionAlgorithm;
    private byte[] encryptedData;

    public ShroudedKeyBag(Asn1 asn1) throws PKCS8Exception, Asn1Exception {
        Debug.dumpAsn1To(asn1, "shroudedkeybag");
        this.initialize(asn1);
    }

    public ShroudedKeyBag(PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey) {
        try {
            Asn1 asn1 = Asn1.getAsn1(pKCS8EncryptedPrivateKey.getEncoded());
            this.initialize(asn1);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception: " + exception.toString());
        }
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public PKCS8EncryptedPrivateKey getEncryptedPrivateKeyInfo() {
        return this.encryptedPrivateKeyInfo;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getType() {
        return SHROUDED_KEYBAG;
    }

    private void initialize(Asn1 asn1) throws PKCS8Exception, Asn1Exception {
        this.asn1 = asn1;
        this.encryptedPrivateKeyInfo = new PKCS8EncryptedPrivateKey(this.asn1.getEncoded());
        try {
            Iterator iterator = this.asn1.components();
            Asn1 asn12 = (Asn1)iterator.next();
            AlgorithmId algorithmId = new AlgorithmId(asn12);
            this.encryptionAlgorithm = algorithmId.getOid();
            OctetString octetString = (OctetString)iterator.next();
            this.encryptedData = octetString.getBytes();
        }
        catch (ClassCastException classCastException) {
            throw new PKCS8Exception("Invalid EncryptedPrivateKeyInfo ASN.1");
        }
    }
}

