/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs7;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Null;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.OID;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AlgorithmId {
    private Asn1 asn1;
    private String algorithm;
    private AlgorithmParameters parameters;
    private Asn1 encodedParameters;

    public AlgorithmId(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null AlgorithmId ASN.1");
        }
        String string = null;
        try {
            Iterator iterator = asn1.components();
            Oid oid = (Oid)iterator.next();
            this.algorithm = oid.getOid();
            string = OID.getAlgName(this.algorithm);
            if (iterator.hasNext()) {
                Asn1 asn12 = (Asn1)iterator.next();
                if (asn12 instanceof Null) {
                    this.parameters = null;
                } else {
                    this.parameters = AlgorithmParameters.getInstance(string);
                    this.parameters.init(asn12.getEncoded());
                    this.encodedParameters = asn12;
                    this.encodedParameters = Asn1.getAsn1(this.parameters.getEncoded());
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid AlgorithmId ASN.1: " + classCastException.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Incomplete Algorithm ASN.1: " + noSuchElementException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Asn1Exception(String.valueOf(noSuchAlgorithmException.toString()) + ": " + string + "(" + this.algorithm + ")");
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    public AlgorithmId(InputStream inputStream) throws IOException, Asn1Exception, NoSuchAlgorithmException {
        this(Asn1.getAsn1(inputStream));
    }

    public AlgorithmId(String string) {
        this.algorithm = string;
    }

    public AlgorithmId(String string, AlgorithmParameters algorithmParameters) throws Asn1Exception, IOException {
        this.algorithm = string;
        this.parameters = algorithmParameters;
        this.encodedParameters = Asn1.getAsn1(this.parameters.getEncoded());
    }

    public AlgorithmId(String string, boolean bl) {
        this.algorithm = string;
    }

    public Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.asn1 = new Sequence();
            this.asn1.add(new Oid(this.algorithm));
            if (this.parameters == null) {
                this.asn1.add(new Null());
            } else {
                this.asn1.add(this.encodedParameters);
            }
        }
        return this.asn1;
    }

    public String getOid() {
        return this.algorithm;
    }

    public AlgorithmParameters getParams() {
        return this.parameters;
    }
}

