/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs7;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.pkcs7.Content;
import com.dstc.security.keymanage.pkcs7.ContentInfoFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ContentInfo {
    private Asn1 asn1 = null;
    private String contentType;
    private Content content;

    public ContentInfo(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("Null ASN.1 Data");
        }
        Iterator iterator = asn1.components();
        try {
            Oid oid = (Oid)iterator.next();
            this.contentType = oid.getOid();
            Asn1 asn12 = (Asn1)iterator.next();
            Iterator iterator2 = asn12.components();
            if (iterator2 == null) {
                throw new Asn1Exception("Invalid ContentInfo ASN.1");
            }
            Asn1 asn13 = (Asn1)iterator2.next();
            this.content = ContentInfoFactory.resolve(this.contentType, asn13);
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid ContentInfo ASN.1");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Incomplete ContentInfo ASN.1");
        }
    }

    public ContentInfo(Content content) {
        if (content == null) {
            throw new NullPointerException();
        }
        this.contentType = content.getContentType();
        this.content = content;
    }

    public ContentInfo(String string, Asn1 asn1) throws Asn1Exception {
        this.contentType = string;
        if (asn1 != null) {
            this.content = ContentInfoFactory.resolve(string, asn1);
        }
    }

    public ContentInfo(String string, Content content) {
        this.contentType = string;
        if (content != null) {
            this.content = content;
        }
    }

    public Content getAsContent() {
        return this.content;
    }

    public Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.asn1 = new Sequence();
            this.asn1.add(new Oid(this.contentType));
            if (this.content != null) {
                Explicit explicit = new Explicit(128, 0);
                explicit.add(this.content.getAsn1());
                this.asn1.add(explicit);
            }
        }
        return this.asn1;
    }

    public Asn1 getContent() {
        return this.content.getAsn1();
    }

    public String getContentType() {
        return this.contentType;
    }
}

