/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs7;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs7.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class EncryptedContentInfo {
    private Asn1 asn1 = null;
    private String contentType;
    private AlgorithmId contentEncryptionAlgorithm;
    private byte[] encryptedContent;

    public EncryptedContentInfo(Asn1 asn1) throws Asn1Exception {
        Debug.log(1, "EncryptedContentInfo( Asn1 )", "");
        if (asn1 == null) {
            throw new Asn1Exception("null ASN.1 data");
        }
        try {
            Iterator iterator = asn1.components();
            Oid oid = (Oid)iterator.next();
            this.contentType = oid.getOid();
            this.contentEncryptionAlgorithm = new AlgorithmId((Asn1)iterator.next());
            if (iterator.hasNext()) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ((Asn1)iterator.next()).writeValue(byteArrayOutputStream);
                this.encryptedContent = byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal error: " + iOException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid EncryptedContentInfo ASN.1: " + classCastException.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Incomplete EncryptedContentInfo ASN.1: " + noSuchElementException.toString());
        }
    }

    public EncryptedContentInfo(String string, AlgorithmId algorithmId, byte[] byArray) {
        this.contentType = string;
        this.contentEncryptionAlgorithm = algorithmId;
        this.encryptedContent = byArray;
    }

    public Asn1 getAsn1() {
        if (this.asn1 == null) {
            this.asn1 = new Sequence();
            this.asn1.add(new Oid(this.contentType));
            this.asn1.add(this.contentEncryptionAlgorithm.getAsn1());
            OctetString octetString = new OctetString(this.encryptedContent);
            octetString.setTagClass(128);
            octetString.setTagNumber(0);
            this.asn1.add(octetString);
        }
        return this.asn1;
    }

    private static byte[] getBytes(OctetString octetString) {
        byte[] byArray = octetString.getBytes();
        if (byArray == null && octetString.isConstructed()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Iterator iterator = octetString.components();
            while (iterator.hasNext()) {
                OctetString octetString2 = (OctetString)iterator.next();
                byte[] byArray2 = EncryptedContentInfo.getBytes(octetString2);
                byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public AlgorithmId getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public Oid getContentType() {
        return new Oid(this.contentType);
    }

    public byte[] getEncryptedContent() {
        return this.encryptedContent;
    }
}

