/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.pkcs7;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.keymanage.debug.Debug;
import com.dstc.security.keymanage.pkcs7.Content;
import com.dstc.security.keymanage.pkcs7.EncryptedContentInfo;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EncryptedData
implements Content {
    private static final int DEFAULT_VERSION = 0;
    private Asn1 asn1 = null;
    private int version = 0;
    private EncryptedContentInfo info = null;

    public EncryptedData(int n, EncryptedContentInfo encryptedContentInfo) {
        this.version = this.version;
        this.info = encryptedContentInfo;
        this.asn1 = new Sequence();
        this.asn1.add(new Integer(this.version));
        this.asn1.add(this.info.getAsn1());
    }

    public EncryptedData(Asn1 asn1) throws Asn1Exception {
        Debug.log(1, "EncryptedData( Asn1 )", "");
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        try {
            Debug.log(1, "EncryptedData( Asn1 )", "Version");
            Integer integer = (Integer)iterator.next();
            this.version = integer.getInt();
            Debug.log(1, "EncryptedData( Asn1 )", "Content");
            Asn1 asn12 = (Asn1)iterator.next();
            Debug.log(1, "EncryptedData( Asn1 )", "Retrieved Asn1");
            this.info = new EncryptedContentInfo(asn12);
            Debug.log(1, "EncryptedData( Asn1 )", "Info");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Asn1Exception("Incomplete EncryptedData ASN.1");
        }
        catch (ClassCastException classCastException) {
            throw new Asn1Exception("Invalid EncryptedData ASN.1");
        }
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo) {
        this(0, encryptedContentInfo);
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getContentType() {
        return "1.2.840.113549.1.7.6";
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.info;
    }

    public int getVersion() {
        return this.version;
    }
}

