/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.keymanage.spi;

import com.dstc.security.keymanage.spi.KeyStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;

public abstract class DSTCKeyStoreEngine
extends KeyStoreSpi {
    protected KeyStore keyStore = null;

    public Enumeration engineAliases() {
        try {
            return this.keyStore.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public boolean engineContainsAlias(String string) {
        try {
            return this.keyStore.containsAlias(string);
        }
        catch (KeyStoreException keyStoreException) {
            return false;
        }
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        try {
            this.keyStore.deleteEntry(string);
        }
        catch (KeyStoreException keyStoreException) {}
    }

    public Certificate engineGetCertificate(String string) {
        try {
            return this.keyStore.getCertificate(string);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        try {
            return this.keyStore.getCertificateAlias(certificate);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public Certificate[] engineGetCertificateChain(String string) {
        try {
            return this.keyStore.getCertificateChain(string);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public Date engineGetCreationDate(String string) {
        try {
            return this.keyStore.getCreationDate(string);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return this.keyStore.getKey(string, cArray);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public boolean engineIsCertificateEntry(String string) {
        try {
            return this.keyStore.isCertificateEntry(string);
        }
        catch (KeyStoreException keyStoreException) {
            return false;
        }
    }

    public boolean engineIsKeyEntry(String string) {
        try {
            return this.keyStore.isKeyEntry(string);
        }
        catch (KeyStoreException keyStoreException) {
            return false;
        }
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            this.keyStore.load(inputStream, cArray);
        }
        catch (KeyStoreException keyStoreException) {}
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        try {
            this.keyStore.setCertificateEntry(string, certificate);
        }
        catch (KeyStoreException keyStoreException) {}
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            this.keyStore.setKeyEntry(string, key, cArray, certificateArray);
        }
        catch (KeyStoreException keyStoreException) {}
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            this.keyStore.setKeyEntry(string, byArray, certificateArray);
        }
        catch (KeyStoreException keyStoreException) {}
    }

    public int engineSize() {
        try {
            return this.keyStore.size();
        }
        catch (KeyStoreException keyStoreException) {
            return 0;
        }
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            this.keyStore.store(outputStream, cArray);
        }
        catch (KeyStoreException keyStoreException) {}
    }
}

