/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.util;

import com.dstc.security.util.Base64;
import com.dstc.security.util.Base64Decoder;
import com.dstc.security.util.Base64Encoder;
import com.dstc.security.util.Base64Exception;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    public static final int ENCODE = 0;
    public static final int DECODE = 1;
    private static final char PAD = '=';
    private Base64 b64;
    private int mode;
    private int BLOCKSIZE;
    private byte[] buffer;
    private byte[] temp;
    private byte[] buf = new byte[1];
    private int bufferOff;
    private int bufferLen;
    private int tempLen;
    private boolean firstRun = true;
    private boolean eof;
    private int ind1;
    private int ind2;
    private int dummy;

    public Base64InputStream(int n, InputStream inputStream) {
        super(inputStream);
        this.mode = n;
        if (n == 1) {
            this.b64 = new Base64Decoder();
            this.BLOCKSIZE = 4;
            this.temp = new byte[2 * this.BLOCKSIZE];
            this.buffer = new byte[3];
        } else {
            this.b64 = new Base64Encoder();
            this.BLOCKSIZE = 3;
            this.temp = new byte[2 * this.BLOCKSIZE];
            this.buffer = new byte[4];
        }
    }

    public Base64InputStream(InputStream inputStream) {
        this(1, inputStream);
    }

    public int available() throws IOException {
        return this.in.available() * 4 / 5;
    }

    public int read() throws IOException {
        int n;
        do {
            if ((n = this.read(this.buf, 0, 1)) != -1) continue;
            return -1;
        } while (n != 1);
        return this.buf[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.firstRun) {
            this.readBlock(this.temp, 0, this.BLOCKSIZE);
            this.firstRun = false;
            this.ind1 = this.BLOCKSIZE;
            this.ind2 = 0;
            this.tempLen = this.BLOCKSIZE;
        }
        if (this.eof && this.bufferLen == 0) {
            return -1;
        }
        if (n2 <= this.bufferLen) {
            System.arraycopy(this.buffer, this.bufferOff, byArray, n, n2);
            this.bufferOff += n2;
            this.bufferLen -= n2;
            return n2;
        }
        System.arraycopy(this.buffer, this.bufferOff, byArray, n, this.bufferLen);
        int n3 = n2 - this.bufferLen;
        int n4 = n + this.bufferLen;
        this.bufferOff = 0;
        this.bufferLen = 0;
        if (this.eof) {
            return n2 - n3;
        }
        try {
            while (true) {
                int n5;
                if ((n5 = this.readBlock(this.temp, this.ind1, this.BLOCKSIZE)) == this.BLOCKSIZE) {
                    this.tempLen = n5;
                    if (n3 < this.BLOCKSIZE) {
                        this.b64.doBlock(this.temp, this.ind2, this.buffer, this.bufferOff);
                        this.bufferLen = this.b64.produced();
                        this.dummy = this.ind1;
                        this.ind1 = this.ind2;
                        this.ind2 = this.dummy;
                        return n2 - n3;
                    }
                    this.b64.doBlock(this.temp, this.ind2, byArray, n4);
                    n3 -= this.b64.produced();
                    n4 += this.b64.produced();
                    this.dummy = this.ind1;
                    this.ind1 = this.ind2;
                    this.ind2 = this.dummy;
                    continue;
                }
                if (n5 == -1) {
                    this.eof = true;
                    if (this.mode == 1) {
                        this.b64.doFinal(this.temp, this.ind2, this.tempLen, this.buffer, this.bufferOff);
                        this.bufferLen = this.b64.produced();
                    } else {
                        this.b64.doBlock(this.temp, this.ind2, byArray, n4);
                        n3 -= this.b64.produced();
                        n4 += this.b64.produced();
                        this.b64.doFinal(this.temp, this.ind1, this.tempLen, this.buffer, this.bufferOff);
                        this.bufferLen = this.b64.produced();
                    }
                    if (this.bufferLen <= n3) {
                        System.arraycopy(this.buffer, this.bufferOff, byArray, n4, this.bufferLen);
                        this.bufferLen = 0;
                        return n2 - (n3 -= this.bufferLen);
                    }
                    return n2 - n3;
                }
                this.tempLen = n5;
            }
        }
        catch (Base64Exception base64Exception) {
            throw new IOException(base64Exception.getMessage());
        }
    }

    private int readBlock(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        do {
            int n4;
            if ((n4 = this.in.read()) != -1) {
                if (this.mode == 1) {
                    if (n4 == 10 || n4 == 13 || n4 == 32 || n4 == 9) continue;
                    byArray[n3++] = (byte)(n4 & 0xFF);
                    continue;
                }
                byArray[n3++] = (byte)(n4 & 0xFF);
                continue;
            }
            if (n3 == n) {
                return -1;
            }
            return n3 - n;
        } while (n3 - n != n2);
        return n2;
    }
}

