/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.util;

import com.dstc.security.util.Base64;
import com.dstc.security.util.Base64Decoder;
import com.dstc.security.util.Base64Encoder;
import com.dstc.security.util.Base64Exception;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    public static final int ENCODE = 0;
    public static final int DECODE = 1;
    private static final int DEFAULT_WIDTH = 16;
    private static final char PAD = '=';
    private int width;
    private int mode;
    private int BLOCKSIZE;
    private byte[] buffer;
    private byte[] temp;
    private int bufferLen;
    private byte[] buf = new byte[1];
    private int count = 0;
    private Base64 b64;

    public Base64OutputStream(int n, int n2, OutputStream outputStream) {
        super(outputStream);
        this.mode = n;
        this.width = n2;
        if (n == 0) {
            this.b64 = new Base64Encoder();
            this.BLOCKSIZE = 3;
            this.buffer = new byte[this.BLOCKSIZE];
            this.temp = new byte[4];
        } else {
            this.b64 = new Base64Decoder();
            this.BLOCKSIZE = 4;
            this.buffer = new byte[this.BLOCKSIZE];
            this.temp = new byte[3];
        }
    }

    public Base64OutputStream(int n, OutputStream outputStream) {
        this(n, 16, outputStream);
    }

    public Base64OutputStream(OutputStream outputStream) {
        this(0, 16, outputStream);
    }

    public void flush() throws IOException {
        try {
            if (this.bufferLen > 0) {
                this.b64.doFinal(this.buffer, 0, this.bufferLen, this.temp, 0);
                this.out.write(this.temp, 0, this.b64.produced());
                this.bufferLen -= this.b64.consumed();
            }
            super.flush();
        }
        catch (Base64Exception base64Exception) {
            throw new IOException(base64Exception.getMessage());
        }
    }

    public void write(int n) throws IOException {
        this.buf[0] = (byte)(n & 0xFF);
        this.write(this.buf);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3 = n;
            int n4 = n2;
            if (this.mode == 1) {
                do {
                    byte by = byArray[n3++];
                    --n4;
                    if (by != 10 && by != 13 && by != 9 && by != 32) {
                        this.buffer[this.bufferLen++] = by;
                    }
                    if (this.bufferLen != this.BLOCKSIZE) continue;
                    if (this.buffer[this.BLOCKSIZE - 1] == 61) {
                        this.flush();
                    } else {
                        this.b64.doBlock(this.buffer, 0, this.temp, 0);
                        this.out.write(this.temp, 0, this.b64.produced());
                    }
                    this.bufferLen = 0;
                } while (n4 != 0);
            } else {
                if (this.bufferLen + n2 >= this.BLOCKSIZE) {
                    int n5 = 0;
                    while (n5 < this.BLOCKSIZE - this.bufferLen) {
                        this.buffer[this.bufferLen + n5] = byArray[n + n5];
                        ++n5;
                    }
                    this.b64.doBlock(this.buffer, 0, this.temp, 0);
                    this.writeBlock(this.temp);
                }
                n3 += this.BLOCKSIZE - this.bufferLen;
                n4 -= this.BLOCKSIZE - this.bufferLen;
                while (n4 > this.BLOCKSIZE) {
                    this.b64.doBlock(byArray, n3, this.temp, 0);
                    n3 += this.b64.consumed();
                    n4 -= this.b64.consumed();
                    this.writeBlock(this.temp);
                }
                this.bufferLen = n4;
                if (this.bufferLen > 0) {
                    System.arraycopy(byArray, n3, this.buffer, 0, n4);
                }
            }
        }
        catch (Base64Exception base64Exception) {
            throw new IOException(base64Exception.getMessage());
        }
    }

    private void writeBlock(byte[] byArray) throws IOException {
        this.out.write(byArray);
        if (this.mode == 0) {
            if (this.count == this.width) {
                this.out.write(10);
                this.count = 0;
            } else {
                ++this.count;
            }
        }
    }
}

