/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.util;

import com.dstc.security.util.UnsatisfiedJarDependency;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Dependencies {
    public static final Attributes.Name EXTENSION_LIST = new Attributes.Name("Extension-List");
    public static final Attributes.Name EXTENSION_NAME = new Attributes.Name("Extension-Name");
    public static final Attributes.Name IMPLEMENTATION_VENDOR_ID = new Attributes.Name("Implementation-Vendor-Id");
    public static final Attributes.Name SPECIFICATION_VERSION = Attributes.Name.SPECIFICATION_VERSION;
    public static final Attributes.Name IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION;
    public static final Attributes.Name IMPLEMENTATION_VENDOR = Attributes.Name.IMPLEMENTATION_VENDOR;

    public static String check(Class clazz) {
        Object object;
        String string;
        Manifest manifest = Dependencies.getManifest(clazz);
        if (manifest != null && (string = ((Attributes)(object = manifest.getMainAttributes())).getValue(EXTENSION_LIST)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                Dependencies.check((Attributes)object, stringTokenizer.nextToken(), clazz);
            }
        }
        return (object = clazz.getPackage()) == null ? null : ((Package)object).getSpecificationVersion();
    }

    public static void check(Attributes attributes, String string, Class clazz) {
        Attributes attributes2;
        String string2 = String.valueOf(string) + "-";
        String string3 = attributes.getValue(String.valueOf(string2) + EXTENSION_NAME).trim();
        if (string3 == null || string3.length() == 0) {
            return;
        }
        String string4 = "/" + string3.replace('.', '/') + '/';
        URL uRL = clazz.getResource(string4);
        try {
            attributes2 = ((JarURLConnection)uRL.openConnection()).getMainAttributes();
        }
        catch (ClassCastException classCastException) {
            throw new UnsatisfiedJarDependency("No package for Extension-Name: " + string3);
        }
        catch (IOException iOException) {
            throw new UnsatisfiedJarDependency("Got " + iOException + " while fetching Manifest for " + string3);
        }
        Dependencies.checkVersion(string2, SPECIFICATION_VERSION, string3, attributes, attributes2);
        Dependencies.checkString(string2, IMPLEMENTATION_VENDOR, string3, attributes, attributes2);
        Dependencies.checkString(string2, IMPLEMENTATION_VENDOR_ID, string3, attributes, attributes2);
        Dependencies.checkVersion(string2, IMPLEMENTATION_VERSION, string3, attributes, attributes2);
    }

    public static void checkString(String string, Attributes.Name name, String string2, Attributes attributes, Attributes attributes2) {
        String string3 = name.toString();
        String string4 = attributes.getValue(String.valueOf(string) + string3);
        if (string4 == null) {
            return;
        }
        String string5 = attributes2.getValue(name);
        if (string5 == null) {
            throw new UnsatisfiedJarDependency("No " + string3 + " for " + string2);
        }
        if (!string5.equals(string4)) {
            throw new UnsatisfiedJarDependency("Needed " + string3 + "=" + string4 + " for package " + string2 + " but got " + string5);
        }
    }

    public static void checkVersion(String string, Attributes.Name name, String string2, Attributes attributes, Attributes attributes2) {
        String string3 = name.toString();
        String string4 = attributes.getValue(String.valueOf(string) + string3);
        if (string4 == null) {
            return;
        }
        String string5 = attributes2.getValue(name);
        if (string5 == null) {
            throw new UnsatisfiedJarDependency("No " + string3 + " for " + string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ".");
        try {
            while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer2.nextToken());
                if (n2 > n) {
                    return;
                }
                if (n2 >= n) continue;
                throw Dependencies.lowVersion(string3, string2, string4, string5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnsatisfiedJarDependency("Malformed " + string3 + ": " + string4 + " or " + string5 + " for package " + string2);
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw Dependencies.lowVersion(string3, string2, string4, string5);
        }
    }

    public static Manifest getManifest(Class clazz) {
        try {
            String string = clazz.getName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            URL uRL = clazz.getResource(String.valueOf(string) + ".class");
            return ((JarURLConnection)uRL.openConnection()).getManifest();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static UnsatisfiedJarDependency lowVersion(String string, String string2, String string3, String string4) {
        return new UnsatisfiedJarDependency("Needed " + string + " >= " + string3 + " for package " + string2 + " but only got " + string4);
    }
}

