/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.ExtensionFactory;
import com.dstc.security.x509.ExtensionValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class Extension {
    protected Asn1 asn1 = null;
    private String extnID;
    private boolean critical = false;
    private ExtensionValue extnValue;

    public Extension() {
    }

    public Extension(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.extnID = ((Oid)iterator.next()).getOid();
        Asn1 asn12 = (Asn1)iterator.next();
        try {
            this.critical = ((Boolean)asn12).isTrue();
            asn12 = (Asn1)iterator.next();
        }
        catch (ClassCastException classCastException) {}
        this.extnValue = ExtensionFactory.getExtension(this.extnID, asn12);
        if (this.extnValue == null) {
            this.extnValue = new UnknownExtensionVal(this.extnID, asn12);
        }
    }

    public Extension(InputStream inputStream) throws IOException, Asn1Exception {
        this(Asn1.getAsn1(inputStream));
    }

    public Extension(String string, boolean bl, ExtensionValue extensionValue) throws Asn1Exception {
        this.extnID = string;
        this.critical = bl;
        this.extnValue = extensionValue;
        this.encode();
    }

    void encode() throws Asn1Exception {
        this.asn1 = new Sequence();
        this.asn1.add(new Oid(this.extnID));
        if (this.critical) {
            this.asn1.add(new Boolean(1));
        }
        this.asn1.add(new OctetString(this.extnValue.getEncoded()));
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getExtnID() {
        return this.extnID;
    }

    public ExtensionValue getExtnValue() {
        return this.extnValue;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public static String printHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Extension.toHexDigit(byArray[n]));
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static String toHexDigit(byte by) {
        char[] cArray = new char[2];
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[0] = c;
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[1] = c;
        return new String(cArray);
    }

    public String toString() {
        return this.extnValue.toString();
    }

    private class UnknownExtensionVal
    implements ExtensionValue {
        private String extnId;
        private Asn1 asn1;

        UnknownExtensionVal(String string, Asn1 asn1) {
            this.extnId = string;
            this.asn1 = asn1;
        }

        public byte[] getEncoded() throws Asn1Exception {
            return this.asn1.getEncoded();
        }

        public String toString() {
            byte[] byArray = null;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Unknown extension:\n");
            stringBuffer.append("  OID:" + this.extnId + "\n");
            try {
                byArray = this.asn1.getEncoded();
            }
            catch (Asn1Exception asn1Exception) {
                throw new RuntimeException("Bad DER encoding");
            }
            stringBuffer.append("    DER encoding:\n            ");
            int n = 0;
            while (n < byArray.length) {
                if (n > 0 && n % 20 == 0) {
                    stringBuffer.append("\n            ");
                }
                if (byArray[n] < 16 && byArray[n] >= 0) {
                    stringBuffer.append("0" + Integer.toHexString(byArray[n] & 0xFF) + " ");
                } else {
                    stringBuffer.append(String.valueOf(Integer.toHexString(byArray[n] & 0xFF)) + " ");
                }
                ++n;
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

