/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.common.X500Name;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GeneralName {
    private Asn1 asn1 = null;
    public static final int RFC822NAME = 1;
    public static final int DNSNAME = 2;
    public static final int DIRECTORYNAME = 4;
    public static final int URL = 6;
    public static final int IPADDRESS = 7;
    private int type;
    private String name;

    private GeneralName(int n, Asn1 asn1) {
        this.asn1 = asn1;
        this.asn1.setTagClass(128);
        this.asn1.setTagNumber(n);
    }

    public GeneralName(int n, String string) {
        this(n, GeneralName.orig(n, string));
        this.type = n;
        this.name = string;
    }

    public GeneralName(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        this.type = asn1.getTagNumber();
        if (this.type == 1 || this.type == 2 || this.type == 6) {
            this.name = new String(asn1.getValue());
        } else if (this.type == 4) {
            Asn1 asn12 = (Asn1)asn1.components().next();
            this.name = new X500Name(asn12).toString();
        } else if (this.type == 7) {
            byte[] byArray = asn1.getValue();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append(byArray[n] & 0xFF);
                if (n != byArray.length - 1) {
                    stringBuffer.append(".");
                }
                ++n;
            }
            this.name = stringBuffer.toString();
        } else {
            this.name = new String(asn1.getEncoded());
        }
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    private static final Asn1 orig(int n, String string) {
        byte[] byArray = null;
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                return new IA5String(string);
            }
            case 4: {
                Explicit explicit = new Explicit(128, 4);
                explicit.add(new X500Name(string).getAsn1());
                return explicit;
            }
            case 7: {
                try {
                    byArray = InetAddress.getByName(string).getAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    throw new RuntimeException("Unknown Host");
                }
                return new OctetString(byArray);
            }
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

