/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.GeneralName;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class GeneralNames {
    private Asn1 asn1 = null;
    private Vector names;

    public GeneralNames(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        this.names = new Vector();
        Iterator iterator = asn1.components();
        while (iterator.hasNext()) {
            this.names.add(new GeneralName((Asn1)iterator.next()));
        }
    }

    public GeneralNames(Vector vector) {
        this.asn1 = new Sequence();
        this.names = vector;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            this.asn1.add(((GeneralName)iterator.next()).getAsn1());
        }
    }

    public void addGeneralName(GeneralName generalName) {
        this.names.add(generalName);
        this.asn1.add(generalName.getAsn1());
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public Vector getNames() {
        return this.names;
    }
}

