/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.SubjectPublicKeyInfo;
import com.dstc.security.common.X500Name;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509.Validity;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;

public class TBSCertificate {
    protected Asn1 asn1 = null;
    protected int version = 0;
    protected BigInteger serialNumber;
    protected X500Name issuer;
    protected X500Name subject;
    protected Validity validity;
    protected AlgorithmId algo;
    protected SubjectPublicKeyInfo spki;
    protected byte[] issuerUniqueId;
    protected byte[] subjectUniqueId;
    public Extensions extns = null;

    public TBSCertificate() {
    }

    public TBSCertificate(Asn1 asn1) throws Asn1Exception, IOException {
        byte[] byArray;
        this.asn1 = asn1;
        if (!(asn1 instanceof Sequence)) {
            throw new Asn1Exception("Bad certificate encoding");
        }
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 0) {
            this.version = ((Integer)asn12.components().next()).getInt();
            asn12 = (Asn1)iterator.next();
        }
        this.serialNumber = ((Integer)asn12).getBigInteger();
        this.algo = new AlgorithmId((Asn1)iterator.next());
        this.issuer = new X500Name((Asn1)iterator.next());
        this.validity = new Validity((Asn1)iterator.next());
        this.subject = new X500Name((Asn1)iterator.next());
        this.spki = new SubjectPublicKeyInfo((Asn1)iterator.next());
        if (!iterator.hasNext()) {
            return;
        }
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 1) {
            byArray = asn12.getValue();
            this.issuerUniqueId = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, this.issuerUniqueId, 0, byArray.length - 1);
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 2) {
            byArray = asn12.getValue();
            this.subjectUniqueId = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, this.subjectUniqueId, 0, byArray.length - 1);
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 3) {
            this.extns = new Extensions((Asn1)asn12.components().next());
        }
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public Extensions getExtensions() {
        return this.extns;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public byte[] getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPubKeyInfo() {
        return this.spki;
    }

    public byte[] getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public int getVersion() {
        return this.version;
    }
}

