/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.x509.TbsCertList;
import com.dstc.security.x509.X509CRLEntry;
import com.dstc.security.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class X509CRL
extends java.security.cert.X509CRL {
    protected Asn1 asn1 = null;
    protected TbsCertList tbsCertList;
    protected AlgorithmId sigAlg;
    protected byte[] signature;
    protected Map bySerialNumber;

    public X509CRL() {
    }

    public X509CRL(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        if (!(asn1 instanceof Sequence)) {
            throw new Asn1Exception("Bad CRL encoding");
        }
        Iterator iterator = asn1.components();
        this.tbsCertList = new TbsCertList((Asn1)iterator.next());
        this.sigAlg = new AlgorithmId((Asn1)iterator.next());
        this.signature = ((BitString)iterator.next()).getBytes();
    }

    public X509CRL(InputStream inputStream) throws Asn1Exception, IOException {
        this(Asn1.getAsn1(inputStream));
    }

    public Set getCriticalExtensionOIDs() {
        return this.tbsCertList.getExtensions().getCriticalOIDs();
    }

    public byte[] getEncoded() throws CRLException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new CRLException(asn1Exception.getMessage());
        }
    }

    public byte[] getExtensionValue(String string) {
        return this.tbsCertList.getExtensions().getValue(string);
    }

    public Principal getIssuerDN() {
        return this.tbsCertList.getIssuer();
    }

    public Date getNextUpdate() {
        if (this.tbsCertList.getNextUpdate() == null) {
            return null;
        }
        return this.tbsCertList.getNextUpdate().getDate();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.tbsCertList.getExtensions().getNonCriticalOIDs();
    }

    public java.security.cert.X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        return (X509CRLEntry)this.getSerialNumberMap().get(bigInteger);
    }

    public Set getRevokedCertificates() {
        return this.tbsCertList.getRevokedCerts();
    }

    protected Map getSerialNumberMap() {
        HashMap<BigInteger, X509CRLEntry> hashMap = this.bySerialNumber;
        if (hashMap == null) {
            hashMap = new HashMap<BigInteger, X509CRLEntry>();
            Set set = this.getRevokedCertificates();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    X509CRLEntry x509CRLEntry = (X509CRLEntry)iterator.next();
                    hashMap.put(x509CRLEntry.getSerialNumber(), x509CRLEntry);
                }
            }
            this.bySerialNumber = hashMap;
        }
        return hashMap;
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.sigAlg.getOid());
    }

    public String getSigAlgOID() {
        return this.sigAlg.getOid();
    }

    public byte[] getSigAlgParams() {
        try {
            return this.sigAlg.getParams().getEncoded();
        }
        catch (IOException iOException) {
            throw new RuntimeException("bad encoding");
        }
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.tbsCertList.getAsn1().getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new CRLException(asn1Exception.getMessage());
        }
    }

    public Date getThisUpdate() {
        return this.tbsCertList.getThisUpdate().getDate();
    }

    public int getVersion() {
        return this.tbsCertList.getVersion();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public boolean isRevoked(Certificate certificate) {
        return this.getRevokedCertificate(((X509Certificate)certificate).getSerialNumber()) != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509 CRL, version ").append(this.getVersion() + 1).append("\n");
        stringBuffer.append("Issuer              : ").append(this.getIssuerDN().getName()).append("\n");
        stringBuffer.append("This Update         : ").append(this.getThisUpdate()).append("\n");
        if (this.getNextUpdate() != null) {
            stringBuffer.append("Next Update         : ").append(this.getNextUpdate()).append("\n");
        }
        if (this.tbsCertList.getExtensions() != null) {
            stringBuffer.append(this.tbsCertList.getExtensions().toString());
        }
        stringBuffer.append("\nRevoked certificates: ").append("\n");
        if (this.getRevokedCertificates() != null) {
            Iterator iterator = this.getRevokedCertificates().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
        }
        return stringBuffer.toString();
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.getSigAlgName());
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        boolean bl = signature.verify(this.getSignature());
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.getSigAlgName(), string);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        boolean bl = signature.verify(this.getSignature());
    }
}

