/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.ExtensionValue;
import com.dstc.security.x509.GeneralNames;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;

public class AuthorityKeyIdentifier
implements ExtensionValue {
    private Asn1 asn1;
    private byte[] keyId;
    private GeneralNames issuer;
    private BigInteger serialNumber;

    public AuthorityKeyIdentifier(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = null;
        if (iterator.hasNext()) {
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 0) {
            this.keyId = asn12.getValue();
        } else if (asn12.getTagNumber() == 1) {
            this.issuer = new GeneralNames(asn12);
            this.serialNumber = new BigInteger(((Asn1)iterator.next()).getValue());
        }
    }

    public AuthorityKeyIdentifier(GeneralNames generalNames, BigInteger bigInteger) throws Asn1Exception, IOException {
        this.asn1 = new Sequence();
        this.issuer = generalNames;
        this.serialNumber = bigInteger;
        Asn1 asn1 = generalNames.getAsn1();
        asn1.setTagClass(128);
        asn1.setTagNumber(1);
        this.asn1.add(asn1);
        Integer integer = new Integer(bigInteger);
        integer.setTagClass(128);
        integer.setTagNumber(2);
        this.asn1.add(integer);
    }

    public AuthorityKeyIdentifier(boolean bl, byte[] byArray) throws Asn1Exception, IOException {
        this.asn1 = new Sequence();
        this.keyId = byArray;
        OctetString octetString = new OctetString(byArray);
        octetString.setTagClass(128);
        octetString.setTagNumber(0);
        this.asn1.add(octetString);
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AuthorityKeyIdentifier extension:\n");
        if (this.issuer != null) {
            stringBuffer.append("    Issuer: " + this.issuer.getNames().toString() + "\n");
            stringBuffer.append("    Serial Number: " + this.serialNumber.toString() + "\n");
        }
        if (this.keyId != null) {
            stringBuffer.append("    " + Extension.printHex(this.keyId));
        }
        return stringBuffer.toString();
    }
}

