/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.ExtensionValue;
import com.dstc.security.x509.extns.PolicyInformation;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class CertificatePolicies
implements ExtensionValue {
    private Asn1 asn1 = null;
    private Collection policyInfos;

    public CertificatePolicies(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.policyInfos = new Vector();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 instanceof Sequence) {
                this.policyInfos.add(new PolicyInformation(asn12));
                continue;
            }
            throw new IOException("Expecting Seq. within CertificatePolicies Extension");
        }
    }

    public CertificatePolicies(Collection collection) throws IOException {
        this.asn1 = new Sequence();
        this.policyInfos = collection;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.asn1.add(((PolicyInformation)iterator.next()).getAsn1());
        }
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public Collection getPolicyInformation() {
        return this.policyInfos;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Certificate Policies extension:\n");
        Iterator iterator = this.policyInfos.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

