/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.ExtensionValue;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ExtendedKeyUsage
implements ExtensionValue {
    private Asn1 asn1 = null;
    private Set extKeyUsages;

    public ExtendedKeyUsage(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Sequence sequence = (Sequence)asn1;
        Iterator iterator = sequence.components();
        this.extKeyUsages = new HashSet();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 instanceof Oid) {
                this.extKeyUsages.add(((Oid)asn12).getOid());
                continue;
            }
            throw new IOException("Expecting OID within ExtendedKeyUsage cert Extension");
        }
    }

    public ExtendedKeyUsage(Set set) throws IOException {
        this.asn1 = new Sequence();
        this.extKeyUsages = set;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.asn1.add(new Oid((String)iterator.next()));
        }
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Extended KeyUsage extension:\n");
        Iterator iterator = this.extKeyUsages.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("1.3.6.1.5.5.7.3.1")) {
                stringBuffer.append("  TLS Web server authentication\n");
                continue;
            }
            if (string.equals("1.3.6.1.5.5.7.3.2")) {
                stringBuffer.append("  TLS Web client Autnentication\n");
                continue;
            }
            if (string.equals("1.3.6.1.5.5.7.3.3")) {
                stringBuffer.append("  Signing of downloadable executable code\n");
                continue;
            }
            if (string.equals("1.3.6.1.5.5.7.3.4")) {
                stringBuffer.append("  E-mail protection\n");
                continue;
            }
            if (string.equals("1.3.6.1.5.5.7.3.8")) {
                stringBuffer.append("  TimeStamping\n");
                continue;
            }
            if (string.equals("1.3.6.1.5.5.7.3.10")) {
                stringBuffer.append("  Data Validation and Certification Service\n");
                continue;
            }
            stringBuffer.append("  " + string + "\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

