/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.x509.ExtensionValue;
import java.io.IOException;

public class KeyUsage
implements ExtensionValue {
    public static final short DIGITAL_SIGNATURE = Short.MIN_VALUE;
    public static final short NON_REPUDIATION = 16384;
    public static final short KEY_ENCIPHERMENT = 8192;
    public static final short DATA_ENCIPHERMENT = 4096;
    public static final short KEY_AGREEMENT = 2048;
    public static final short KEY_CERT_SIGN = 1024;
    public static final short CRL_SIGN = 512;
    public static final short ENCIPHER_ONLY = 256;
    public static final short DECIPHER_ONLY = 128;
    private short usage;
    private Asn1 asn1;

    public KeyUsage(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        byte[] byArray = ((BitString)asn1).getBytes();
        this.usage = (short)(byArray[0] << 8 & 0xFFFF);
        if (byArray.length == 2) {
            this.usage = (short)(this.usage | (short)(byArray[1] & 0xFF));
        }
    }

    public KeyUsage(short s) throws Asn1Exception, IOException {
        this.usage = s;
        byte[] byArray = new byte[]{(byte)(s >>> 8 & 0xFF), (byte)(s & 0xFF)};
        this.asn1 = new BitString(byArray);
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public boolean[] getKeyUsage() {
        boolean[] blArray = new boolean[9];
        if ((this.usage & Short.MIN_VALUE) != 0) {
            blArray[0] = true;
        }
        if ((this.usage & 0x4000) != 0) {
            blArray[1] = true;
        }
        if ((this.usage & 0x2000) != 0) {
            blArray[2] = true;
        }
        if ((this.usage & 0x1000) != 0) {
            blArray[3] = true;
        }
        if ((this.usage & 0x800) != 0) {
            blArray[4] = true;
        }
        if ((this.usage & 0x400) != 0) {
            blArray[5] = true;
        }
        if ((this.usage & 0x200) != 0) {
            blArray[6] = true;
        }
        if ((this.usage & 0x100) != 0) {
            blArray[7] = true;
        }
        if ((this.usage & 0x80) != 0) {
            blArray[8] = true;
        }
        return blArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("KeyUsage extension:\n");
        if ((this.usage & Short.MIN_VALUE) != 0) {
            stringBuffer.append("  DIGITAL SIGNATURE\n");
        }
        if ((this.usage & 0x4000) != 0) {
            stringBuffer.append("  NON REPUDIATION\n");
        }
        if ((this.usage & 0x2000) != 0) {
            stringBuffer.append("  KEY ENCIPHERMENT\n");
        }
        if ((this.usage & 0x1000) != 0) {
            stringBuffer.append("  DATA ENCIPHERMENT\n");
        }
        if ((this.usage & 0x800) != 0) {
            stringBuffer.append("  KEY AGREEMENT\n");
        }
        if ((this.usage & 0x400) != 0) {
            stringBuffer.append("  KEY CERT SIGN\n");
        }
        if ((this.usage & 0x200) != 0) {
            stringBuffer.append("  CRL SIGN\n");
        }
        if ((this.usage & 0x100) != 0) {
            stringBuffer.append("  ENCIPHER ONLY\n");
        }
        if ((this.usage & 0x80) != 0) {
            stringBuffer.append("  DECIPHER ONLY\n");
        }
        return stringBuffer.toString();
    }
}

