/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.ExtensionValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;

public class PolicyConstraints
implements ExtensionValue {
    private Asn1 asn1 = null;
    private int requireExplicitPolicy = -1;
    private int inhibitPolicyMapping = -1;

    public PolicyConstraints(int n, int n2) throws IOException {
        Integer integer;
        if (n < 0 && n2 < 0) {
            throw new IllegalArgumentException("At least one of the requireExplicitPolicy or inhibitPolicyMapping MUST be present");
        }
        this.asn1 = new Sequence();
        this.requireExplicitPolicy = n;
        if (n >= 0) {
            integer = new Integer(n);
            integer.setTagClass(128);
            integer.setTagNumber(0);
            this.asn1.add(integer);
        }
        this.inhibitPolicyMapping = n2;
        if (n2 >= 0) {
            integer = new Integer(n2);
            integer.setTagClass(128);
            integer.setTagNumber(1);
            this.asn1.add(integer);
        }
    }

    public PolicyConstraints(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        if (!iterator.hasNext()) {
            System.out.println("PolicyConstraints is null sequence");
            return;
        }
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() == 0) {
            this.requireExplicitPolicy = new BigInteger(asn12.getValue()).intValue();
            if (!iterator.hasNext()) {
                return;
            }
            asn12 = (Asn1)iterator.next();
        }
        if (asn12.getTagNumber() == 1) {
            this.inhibitPolicyMapping = new BigInteger(asn12.getValue()).intValue();
            if (!iterator.hasNext()) {
                return;
            }
        }
        throw new IOException("Unknown PolicyConstraints certificate extension");
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public int getInhibitPolicyMapping() {
        return this.inhibitPolicyMapping;
    }

    public int getRequireExplicitPolicy() {
        return this.requireExplicitPolicy;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyConstraints extension:\n");
        if (this.requireExplicitPolicy >= 0) {
            stringBuffer.append("  Require Explicit Policy path length = " + this.requireExplicitPolicy + "\n");
        }
        if (this.inhibitPolicyMapping >= 0) {
            stringBuffer.append("  Inhibit Policy Mapping path length = " + this.inhibitPolicyMapping + "\n");
        }
        return stringBuffer.toString();
    }
}

