/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.extns.PolicyQualifierInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class PolicyInformation {
    private Asn1 asn1;
    private String policyIdentifier;
    private Collection policyQualifiers;

    public PolicyInformation(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.policyIdentifier = ((Oid)iterator.next()).getOid();
        this.policyQualifiers = new Vector();
        if (iterator.hasNext()) {
            Iterator iterator2 = ((Sequence)iterator.next()).components();
            while (iterator2.hasNext()) {
                this.policyQualifiers.add(new PolicyQualifierInfo((Asn1)iterator2.next()));
            }
        }
    }

    public PolicyInformation(String string) throws IOException {
        this(string, null);
    }

    public PolicyInformation(String string, Collection collection) throws IOException {
        this.asn1 = new Sequence();
        this.policyIdentifier = string;
        this.asn1.add(new Oid(string));
        if (collection != null) {
            this.policyQualifiers = collection;
            Iterator iterator = collection.iterator();
            Sequence sequence = new Sequence();
            while (iterator.hasNext()) {
                sequence.add(((PolicyQualifierInfo)iterator.next()).getAsn1());
            }
            this.asn1.add(sequence);
        }
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public String getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public Collection getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  Policy Identifier: " + this.policyIdentifier + "\n");
        if (this.policyQualifiers != null && this.policyQualifiers.size() > 0) {
            stringBuffer.append(this.policyQualifiers.toString());
        }
        return stringBuffer.toString();
    }
}

