/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.extns.CPSuri;
import com.dstc.security.x509.extns.Qualifier;
import com.dstc.security.x509.extns.UserNotice;
import java.io.IOException;
import java.util.Iterator;

public class PolicyQualifierInfo {
    private Asn1 asn1;
    private String qualifierIdentifier;
    private Qualifier policyQualifier;

    public PolicyQualifierInfo(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.qualifierIdentifier = ((Oid)iterator.next()).getOid();
        this.policyQualifier = this.qualifierIdentifier.equals("1.3.6.1.5.5.7.2.1") ? new CPSuri((Asn1)iterator.next()) : (this.qualifierIdentifier.equals("1.3.6.1.5.5.7.2.2") ? new UserNotice((Asn1)iterator.next()) : new UnknownPQ((Asn1)iterator.next()));
    }

    public PolicyQualifierInfo(String string, Qualifier qualifier) throws IOException {
        this.asn1 = new Sequence();
        this.qualifierIdentifier = string;
        this.asn1.add(new Oid(string));
        this.policyQualifier = qualifier;
        this.asn1.add(qualifier.getAsn1());
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public Qualifier getQualifier() {
        return this.policyQualifier;
    }

    public String getQualifierIdentifier() {
        return this.qualifierIdentifier;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  Policy Qualifier Identifier: " + this.qualifierIdentifier + "\n");
        stringBuffer.append("    " + this.policyQualifier.toString());
        return stringBuffer.toString();
    }

    private class UnknownPQ
    extends Qualifier {
        UnknownPQ(Asn1 asn1) {
            this.asn1 = asn1;
        }

        public String toString() {
            byte[] byArray = null;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                byArray = this.asn1.getEncoded();
            }
            catch (Asn1Exception asn1Exception) {
                throw new RuntimeException("Bad DER encoding");
            }
            stringBuffer.append("  DER encoding:\n            ");
            int n = 0;
            while (n < byArray.length) {
                if (n > 0 && n % 20 == 0) {
                    stringBuffer.append("\n            ");
                }
                if (byArray[n] < 16 && byArray[n] >= 0) {
                    stringBuffer.append("0" + Integer.toHexString(byArray[n] & 0xFF) + " ");
                } else {
                    stringBuffer.append(String.valueOf(Integer.toHexString(byArray[n] & 0xFF)) + " ");
                }
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

