/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.ExtensionValue;
import java.io.IOException;

public class SubjectKeyIdentifier
implements ExtensionValue {
    private byte[] keyId;
    private Asn1 asn1;

    public SubjectKeyIdentifier(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        this.keyId = ((OctetString)asn1).getBytes();
    }

    public SubjectKeyIdentifier(boolean bl, byte[] byArray) throws Asn1Exception, IOException {
        this.keyId = byArray;
        this.asn1 = new OctetString(byArray);
    }

    public SubjectKeyIdentifier(byte[] byArray) throws Asn1Exception, IOException {
        this.keyId = byArray;
        this.asn1 = new OctetString(byArray);
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public byte[] getKeyID() {
        return this.keyId;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubjectKeyIdentifier extension:\n");
        stringBuffer.append("  " + Extension.printHex(this.keyId));
        return stringBuffer.toString();
    }
}

